/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class SunMiscUnsafeGenerator {
    private static final String UNSAFE_NAME = "sun/misc/Unsafe";
    private static final String UNSAFE_DESC = "Lsun/misc/Unsafe;";
    private final Class<?> internalUnsafeClass;
    private final List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
    private final List<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();

    public SunMiscUnsafeGenerator(Class<?> internalUnsafeClass) {
        this.internalUnsafeClass = internalUnsafeClass;
        this.addFields();
        this.addMethods();
    }

    private void addFields() {
        this.addField("INVALID_FIELD_OFFSET", Integer.TYPE);
        this.addField("ARRAY_BOOLEAN_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_BYTE_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_SHORT_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_CHAR_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_INT_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_LONG_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_FLOAT_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_DOUBLE_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_OBJECT_BASE_OFFSET", Integer.TYPE);
        this.addField("ARRAY_BOOLEAN_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_BYTE_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_SHORT_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_CHAR_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_INT_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_LONG_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_FLOAT_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_DOUBLE_INDEX_SCALE", Integer.TYPE);
        this.addField("ARRAY_OBJECT_INDEX_SCALE", Integer.TYPE);
        this.addField("ADDRESS_SIZE", Integer.TYPE);
    }

    private boolean hasSuitableField(String name, Class<?> type) {
        try {
            Field field = this.internalUnsafeClass.getDeclaredField(name);
            return Modifier.isPublic(field.getModifiers()) && field.getType() == type;
        }
        catch (NoSuchFieldException exception) {
            return false;
        }
    }

    private void addField(String name, Class<?> type) {
        if (!this.hasSuitableField(name, type)) {
            throw new IllegalStateException("Could not find suitable field for " + name + " " + Type.getDescriptor(type));
        }
        this.fields.add(new FieldDescriptor(name, type));
    }

    private void addMethods() {
        this.addMethod("compareAndSwapObject", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Object.class);
        this.addMethod("compareAndSwapInt", Boolean.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        this.addMethod("compareAndSwapLong", Boolean.TYPE, Object.class, Long.TYPE, Long.TYPE, Long.TYPE);
        this.addMethod("putOrderedObject", Void.TYPE, Object.class, Long.TYPE, Object.class);
        this.addMethod("putOrderedInt", Void.TYPE, Object.class, Long.TYPE, Integer.TYPE);
        this.addMethod("putOrderedLong", Void.TYPE, Object.class, Long.TYPE, Long.TYPE);
        this.addMethod("allocateInstance", Object.class, Class.class);
        this.addMethod("loadFence", Void.TYPE, new Class[0]);
        this.addMethod("storeFence", Void.TYPE, new Class[0]);
        this.addMethod("fullFence", Void.TYPE, new Class[0]);
        this.addMethod("getObject", Object.class, Object.class, Long.TYPE);
        this.addMethod("putObject", Void.TYPE, Object.class, Long.TYPE, Object.class);
        this.addMethod("getBoolean", Boolean.TYPE, Object.class, Long.TYPE);
        this.addMethod("putBoolean", Void.TYPE, Object.class, Long.TYPE, Boolean.TYPE);
        this.addMethod("getByte", Byte.TYPE, Long.TYPE);
        this.addMethod("getByte", Byte.TYPE, Object.class, Long.TYPE);
        this.addMethod("putByte", Void.TYPE, Long.TYPE, Byte.TYPE);
        this.addMethod("putByte", Void.TYPE, Object.class, Long.TYPE, Byte.TYPE);
        this.addMethod("getShort", Short.TYPE, Long.TYPE);
        this.addMethod("getShort", Short.TYPE, Object.class, Long.TYPE);
        this.addMethod("putShort", Void.TYPE, Long.TYPE, Short.TYPE);
        this.addMethod("putShort", Void.TYPE, Object.class, Long.TYPE, Short.TYPE);
        this.addMethod("getChar", Character.TYPE, Long.TYPE);
        this.addMethod("getChar", Character.TYPE, Object.class, Long.TYPE);
        this.addMethod("putChar", Void.TYPE, Object.class, Long.TYPE, Character.TYPE);
        this.addMethod("putChar", Void.TYPE, Long.TYPE, Character.TYPE);
        this.addMethod("getInt", Integer.TYPE, Object.class, Long.TYPE);
        this.addMethod("getInt", Integer.TYPE, Long.TYPE);
        this.addMethod("putInt", Void.TYPE, Long.TYPE, Integer.TYPE);
        this.addMethod("putInt", Void.TYPE, Object.class, Long.TYPE, Integer.TYPE);
        this.addMethod("getLong", Long.TYPE, Long.TYPE);
        this.addMethod("getLong", Long.TYPE, Object.class, Long.TYPE);
        this.addMethod("putLong", Void.TYPE, Long.TYPE, Long.TYPE);
        this.addMethod("putLong", Void.TYPE, Object.class, Long.TYPE, Long.TYPE);
        this.addMethod("getFloat", Float.TYPE, Long.TYPE);
        this.addMethod("getFloat", Float.TYPE, Object.class, Long.TYPE);
        this.addMethod("putFloat", Void.TYPE, Object.class, Long.TYPE, Float.TYPE);
        this.addMethod("putFloat", Void.TYPE, Long.TYPE, Float.TYPE);
        this.addMethod("getDouble", Double.TYPE, Object.class, Long.TYPE);
        this.addMethod("getDouble", Double.TYPE, Long.TYPE);
        this.addMethod("putDouble", Void.TYPE, Object.class, Long.TYPE, Double.TYPE);
        this.addMethod("putDouble", Void.TYPE, Long.TYPE, Double.TYPE);
        this.addMethod("getObjectVolatile", Object.class, Object.class, Long.TYPE);
        this.addMethod("putObjectVolatile", Void.TYPE, Object.class, Long.TYPE, Object.class);
        this.addMethod("getBooleanVolatile", Boolean.TYPE, Object.class, Long.TYPE);
        this.addMethod("putBooleanVolatile", Void.TYPE, Object.class, Long.TYPE, Boolean.TYPE);
        this.addMethod("getByteVolatile", Byte.TYPE, Object.class, Long.TYPE);
        this.addMethod("putByteVolatile", Void.TYPE, Object.class, Long.TYPE, Byte.TYPE);
        this.addMethod("getShortVolatile", Short.TYPE, Object.class, Long.TYPE);
        this.addMethod("putShortVolatile", Void.TYPE, Object.class, Long.TYPE, Short.TYPE);
        this.addMethod("getCharVolatile", Character.TYPE, Object.class, Long.TYPE);
        this.addMethod("putCharVolatile", Void.TYPE, Object.class, Long.TYPE, Character.TYPE);
        this.addMethod("getIntVolatile", Integer.TYPE, Object.class, Long.TYPE);
        this.addMethod("putIntVolatile", Void.TYPE, Object.class, Long.TYPE, Integer.TYPE);
        this.addMethod("getLongVolatile", Long.TYPE, Object.class, Long.TYPE);
        this.addMethod("putLongVolatile", Void.TYPE, Object.class, Long.TYPE, Long.TYPE);
        this.addMethod("getFloatVolatile", Float.TYPE, Object.class, Long.TYPE);
        this.addMethod("putFloatVolatile", Void.TYPE, Object.class, Long.TYPE, Float.TYPE);
        this.addMethod("getDoubleVolatile", Double.TYPE, Object.class, Long.TYPE);
        this.addMethod("putDoubleVolatile", Void.TYPE, Object.class, Long.TYPE, Double.TYPE);
        this.addMethod("getAndAddInt", Integer.TYPE, Object.class, Long.TYPE, Integer.TYPE);
        this.addMethod("getAndAddLong", Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
        this.addMethod("getAndSetInt", Integer.TYPE, Object.class, Long.TYPE, Integer.TYPE);
        this.addMethod("getAndSetLong", Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
        this.addMethod("getAndSetObject", Object.class, Object.class, Long.TYPE, Object.class);
        this.addMethod("park", Void.TYPE, Boolean.TYPE, Long.TYPE);
        this.addMethod("unpark", Void.TYPE, Object.class);
        this.addMethod("throwException", Void.TYPE, Throwable.class);
        this.addMethod("objectFieldOffset", Long.TYPE, Field.class);
        this.addMethod("staticFieldBase", Object.class, Field.class);
        this.addMethod("staticFieldOffset", Long.TYPE, Field.class);
        this.addMethod("shouldBeInitialized", Boolean.TYPE, Class.class);
        this.addMethod("ensureClassInitialized", Void.TYPE, Class.class);
        this.addMethod("getAddress", Long.TYPE, Long.TYPE);
        this.addMethod("putAddress", Void.TYPE, Long.TYPE, Long.TYPE);
        this.addMethod("allocateMemory", Long.TYPE, Long.TYPE);
        this.addMethod("reallocateMemory", Long.TYPE, Long.TYPE, Long.TYPE);
        this.addMethod("setMemory", Void.TYPE, Long.TYPE, Long.TYPE, Byte.TYPE);
        this.addMethod("setMemory", Void.TYPE, Object.class, Long.TYPE, Long.TYPE, Byte.TYPE);
        this.addMethod("copyMemory", Void.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        this.addMethod("copyMemory", Void.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
        this.addMethod("freeMemory", Void.TYPE, Long.TYPE);
        this.addMethod("arrayBaseOffset", Integer.TYPE, Class.class);
        this.addMethod("arrayIndexScale", Integer.TYPE, Class.class);
        this.addMethod("addressSize", Integer.TYPE, new Class[0]);
        this.addMethod("pageSize", Integer.TYPE, new Class[0]);
        this.addMethod("getLoadAverage", Integer.TYPE, double[].class, Integer.TYPE);
        this.addOptionalMethod("defineAnonymousClass", Class.class, Class.class, byte[].class, Object[].class);
        this.addOptionalMethod("invokeCleaner", Void.TYPE, ByteBuffer.class);
    }

    private static List<String> getNameCandidates(String name) {
        if (((String)name).startsWith("compareAndSwap")) {
            name = ((String)name).replace("compareAndSwap", "compareAndSet");
        } else if (((String)name).startsWith("putOrdered")) {
            name = ((String)name).replace("putOrdered", "put") + "Release";
        }
        if (((String)name).contains("Object")) {
            String alternativeName = ((String)name).replace("Object", "Reference");
            return Arrays.asList(name, alternativeName);
        }
        return Collections.singletonList(name);
    }

    private void addOptionalMethod(String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.addMethod(name, true, SunMiscUnsafeGenerator.getNameCandidates(name), returnType, parameterTypes);
    }

    private void addMethod(String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.addMethod(name, false, SunMiscUnsafeGenerator.getNameCandidates(name), returnType, parameterTypes);
    }

    private void addMethod(String name, boolean optional, List<String> targetNameCandidates, Class<?> returnType, Class<?> ... parameterTypes) {
        String targetName = null;
        for (String candidate : targetNameCandidates) {
            if (!this.hasSuitableMethod(candidate, returnType, parameterTypes)) continue;
            targetName = candidate;
            break;
        }
        if (targetName == null) {
            if (optional) {
                return;
            }
            throw new IllegalStateException("Could not find suitable method for " + name + " " + Type.getMethodDescriptor((Type)Type.getType(returnType), (Type[])SunMiscUnsafeGenerator.toTypes(parameterTypes)));
        }
        this.methods.add(new MethodDescriptor(name, targetName, returnType, parameterTypes));
    }

    private boolean hasSuitableMethod(String name, Class<?> returnType, Class<?> ... parameterTypes) {
        try {
            Method method = this.internalUnsafeClass.getDeclaredMethod(name, parameterTypes);
            return Modifier.isPublic(method.getModifiers()) && method.getReturnType() == returnType;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Type[] toTypes(Class<?> ... classes) {
        Type[] result = new Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = Type.getType(classes[i]);
        }
        return result;
    }

    private byte[] getBytes() {
        ClassWriter cw;
        ClassWriter cv = cw = new ClassWriter(1);
        cv.visit(49, 49, UNSAFE_NAME, null, "java/lang/Object", null);
        FieldVisitor fv = cv.visitField(26, "theUnsafe", UNSAFE_DESC, null, null);
        fv.visitEnd();
        fv = cv.visitField(26, "theInternalUnsafe", Type.getDescriptor(this.internalUnsafeClass), null, null);
        fv.visitEnd();
        Object mv = cv.visitMethod(2, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (FieldDescriptor field : this.fields) {
            FieldVisitor fv2 = cv.visitField(25, field.name, Type.getDescriptor(field.type), null, null);
            fv2.visitEnd();
        }
        for (MethodDescriptor method : this.methods) {
            Type[] parameters = SunMiscUnsafeGenerator.toTypes(method.parameterTypes);
            Type returnType = Type.getType(method.returnType);
            String descriptor = Type.getMethodDescriptor((Type)returnType, (Type[])parameters);
            MethodVisitor mv2 = cv.visitMethod(1, method.name, descriptor, null, null);
            mv2.visitCode();
            mv2.visitFieldInsn(178, UNSAFE_NAME, "theInternalUnsafe", Type.getDescriptor(this.internalUnsafeClass));
            int slot = 1;
            for (Type parameter : parameters) {
                mv2.visitVarInsn(parameter.getOpcode(21), slot);
                slot += parameter.getSize();
            }
            mv2.visitMethodInsn(182, Type.getInternalName(this.internalUnsafeClass), method.targetName, descriptor, false);
            mv2.visitInsn(returnType.getOpcode(172));
            mv2.visitMaxs(0, 0);
            mv2.visitEnd();
        }
        mv = cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, UNSAFE_NAME);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, UNSAFE_NAME, "<init>", "()V", false);
        mv.visitFieldInsn(179, UNSAFE_NAME, "theUnsafe", UNSAFE_DESC);
        mv.visitMethodInsn(184, Type.getInternalName(this.internalUnsafeClass), "getUnsafe", "()" + Type.getDescriptor(this.internalUnsafeClass), false);
        mv.visitFieldInsn(179, UNSAFE_NAME, "theInternalUnsafe", Type.getDescriptor(this.internalUnsafeClass));
        for (FieldDescriptor field : this.fields) {
            mv.visitFieldInsn(178, Type.getInternalName(this.internalUnsafeClass), field.name, Type.getDescriptor(field.type));
            mv.visitFieldInsn(179, UNSAFE_NAME, field.name, Type.getDescriptor(field.type));
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cv.visitEnd();
        return cw.toByteArray();
    }

    public static void generateUnsafe(Class<?> internalUnsafeClass, AgentClassLoader agentClassLoader) {
        SunMiscUnsafeGenerator generator = new SunMiscUnsafeGenerator(internalUnsafeClass);
        agentClassLoader.defineClass("sun.misc.Unsafe", generator.getBytes());
    }

    private static class FieldDescriptor {
        final String name;
        final Class<?> type;

        FieldDescriptor(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }
    }

    private static class MethodDescriptor {
        final String name;
        final String targetName;
        final Class<?> returnType;
        final Class<?>[] parameterTypes;

        MethodDescriptor(String name, String targetName, Class<?> returnType, Class<?>[] parameterTypes) {
            this.name = name;
            this.targetName = targetName;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }
    }
}

