/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import java.lang.invoke.MutableCallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class AdviceBootstrapState
implements AutoCloseable {
    private static final ThreadLocal<Map<Key, AdviceBootstrapState>> stateForCurrentThread = ThreadLocal.withInitial(HashMap::new);
    private final Key key;
    private int recursionDepth;
    @Nullable
    private MutableCallSite nestedCallSite;
    private static final Function<Key, AdviceBootstrapState> CONSTRUCTOR = AdviceBootstrapState::new;

    private AdviceBootstrapState(Key key) {
        this.key = key;
        this.recursionDepth = -1;
    }

    static void initialize() {
        stateForCurrentThread.get();
        stateForCurrentThread.remove();
        try {
            Class.forName(Key.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static AdviceBootstrapState enter(Class<?> instrumentedClass, String moduleClassName, String adviceClassName, String adviceMethodName, String adviceMethodDescriptor) {
        Key key = new Key(instrumentedClass, moduleClassName, adviceClassName, adviceMethodName, adviceMethodDescriptor);
        AdviceBootstrapState state = stateForCurrentThread.get().computeIfAbsent(key, CONSTRUCTOR);
        ++state.recursionDepth;
        return state;
    }

    public boolean isNestedInvocation() {
        return this.recursionDepth > 0;
    }

    public MutableCallSite getOrInitMutableCallSite(Supplier<MutableCallSite> initializer) {
        if (this.nestedCallSite == null) {
            this.nestedCallSite = initializer.get();
        }
        return this.nestedCallSite;
    }

    public void initMutableCallSite(MutableCallSite mutableCallSite) {
        if (this.nestedCallSite != null) {
            throw new IllegalStateException("callsite has already been initialized");
        }
        this.nestedCallSite = mutableCallSite;
    }

    @Nullable
    public MutableCallSite getMutableCallSite() {
        return this.nestedCallSite;
    }

    @Override
    public void close() {
        if (this.recursionDepth == 0) {
            Map<Key, AdviceBootstrapState> stateMap = stateForCurrentThread.get();
            stateMap.remove(this.key);
            if (stateMap.isEmpty()) {
                stateForCurrentThread.remove();
            }
        } else {
            --this.recursionDepth;
        }
    }

    private static class Key {
        private final Class<?> instrumentedClass;
        private final String moduleClassName;
        private final String adviceClassName;
        private final String adviceMethodName;
        private final String adviceMethodDescriptor;

        private Key(Class<?> instrumentedClass, String moduleClassName, String adviceClassName, String adviceMethodName, String adviceMethodDescriptor) {
            this.instrumentedClass = instrumentedClass;
            this.moduleClassName = moduleClassName;
            this.adviceClassName = adviceClassName;
            this.adviceMethodName = adviceMethodName;
            this.adviceMethodDescriptor = adviceMethodDescriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return this.instrumentedClass.equals(that.instrumentedClass) && this.moduleClassName.equals(that.moduleClassName) && this.adviceClassName.equals(that.adviceClassName) && this.adviceMethodName.equals(that.adviceMethodName) && this.adviceMethodDescriptor.equals(that.adviceMethodDescriptor);
        }

        public int hashCode() {
            int result = this.instrumentedClass.hashCode();
            result = 31 * result + this.moduleClassName.hashCode();
            result = 31 * result + this.adviceClassName.hashCode();
            result = 31 * result + this.adviceMethodName.hashCode();
            result = 31 * result + this.adviceMethodDescriptor.hashCode();
            return result;
        }
    }
}

