/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.instrumentation.internal.ExperimentalInstrumentationModule;
import io.opentelemetry.javaagent.tooling.BytecodeWithUrl;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.LookupExposer;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.StringMatcher;

public class InstrumentationModuleClassLoader
extends ClassLoader {
    private static final ClassLoader BOOT_LOADER;
    private static final Map<String, BytecodeWithUrl> ALWAYS_INJECTED_CLASSES;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final MethodHandle FIND_PACKAGE_METHOD;
    private final Map<String, BytecodeWithUrl> additionalInjectedClasses = new ConcurrentHashMap<String, BytecodeWithUrl>();
    private final ClassLoader agentOrExtensionCl;
    private volatile MethodHandles.Lookup cachedLookup;
    @Nullable
    private final ClassLoader instrumentedCl;
    private final ElementMatcher<String> agentClassNamesMatcher;
    private final Set<String> hiddenAgentPackages;
    private final Set<InstrumentationModule> installedModules = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final Map<String, byte[]> bytecodeOverride;

    public InstrumentationModuleClassLoader(ClassLoader instrumentedCl, ClassLoader agentOrExtensionCl) {
        this(instrumentedCl, agentOrExtensionCl, (ElementMatcher<String>)new StringMatcher("io.opentelemetry.javaagent", StringMatcher.Mode.STARTS_WITH));
    }

    InstrumentationModuleClassLoader(@Nullable ClassLoader instrumentedCl, ClassLoader agentOrExtensionCl, ElementMatcher<String> classesToLoadFromAgentOrExtensionCl) {
        super(agentOrExtensionCl);
        this.agentOrExtensionCl = agentOrExtensionCl;
        this.instrumentedCl = instrumentedCl;
        this.agentClassNamesMatcher = classesToLoadFromAgentOrExtensionCl;
        this.hiddenAgentPackages = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public MethodHandles.Lookup getLookup() {
        if (this.cachedLookup == null) {
            try {
                MethodType getLookupType = MethodType.methodType(MethodHandles.Lookup.class);
                Class<?> lookupExposer = this.loadClass(LookupExposer.class.getName());
                this.cachedLookup = MethodHandles.publicLookup().findStatic(lookupExposer, "getLookup", getLookupType).invoke();
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        return this.cachedLookup;
    }

    public synchronized void installModule(InstrumentationModule module) {
        if (module.getClass().getClassLoader() != this.agentOrExtensionCl) {
            throw new IllegalArgumentException(module.getClass().getName() + " is not loaded by " + this.agentOrExtensionCl);
        }
        if (!this.installedModules.add(module)) {
            return;
        }
        Map<String, BytecodeWithUrl> classesToInject = InstrumentationModuleClassLoader.getClassesToInject(module).stream().collect(Collectors.toMap(className -> className, className -> BytecodeWithUrl.create((String)className, (ClassLoader)this.agentOrExtensionCl)));
        this.installInjectedClasses(classesToInject);
        if (module instanceof ExperimentalInstrumentationModule) {
            this.hiddenAgentPackages.addAll(((ExperimentalInstrumentationModule)module).agentPackagesToHide());
        }
    }

    public synchronized boolean hasModuleInstalled(InstrumentationModule module) {
        return this.installedModules.contains(module);
    }

    synchronized void installInjectedClasses(Map<String, BytecodeWithUrl> classesToInject) {
        classesToInject.forEach(this.additionalInjectedClasses::putIfAbsent);
    }

    private static Set<String> getClassesToInject(InstrumentationModule module) {
        HashSet<String> toInject = new HashSet<String>(InstrumentationModuleMuzzle.getHelperClassNames((InstrumentationModule)module));
        toInject.addAll(InstrumentationModuleClassLoader.getModuleAdviceNames(module));
        if (module instanceof ExperimentalInstrumentationModule) {
            toInject.removeAll(((ExperimentalInstrumentationModule)module).injectedClassNames());
        }
        return toInject;
    }

    private static Set<String> getModuleAdviceNames(InstrumentationModule module) {
        final HashSet<String> adviceNames = new HashSet<String>();
        TypeTransformer nameCollector = new TypeTransformer(){

            public void applyAdviceToMethod(ElementMatcher<? super MethodDescription> methodMatcher, Function<Advice.WithCustomMapping, Advice.WithCustomMapping> mappingCustomizer, String adviceClassName) {
                adviceNames.add(adviceClassName);
            }

            public void applyTransformer(AgentBuilder.Transformer transformer) {
            }
        };
        for (TypeInstrumentation instr : module.typeInstrumentations()) {
            instr.transform(nameCollector);
        }
        return adviceNames;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            BytecodeWithUrl injected;
            Class<Object> result = this.findLoadedClass(name);
            if (result == null && (injected = this.getInjectedClass(name)) != null) {
                byte[] bytecode = bytecodeOverride.get(name) != null ? bytecodeOverride.get(name) : injected.getBytecode();
                result = System.getSecurityManager() == null ? this.defineClassWithPackage(name, bytecode) : AccessController.doPrivileged(() -> this.defineClassWithPackage(name, bytecode));
            }
            if (result == null && this.shouldLoadFromAgent(name)) {
                result = InstrumentationModuleClassLoader.tryLoad(this.agentOrExtensionCl, name);
            }
            if (result == null) {
                result = InstrumentationModuleClassLoader.tryLoad(this.instrumentedCl, name);
            }
            if (result != null) {
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    private boolean shouldLoadFromAgent(String dotClassName) {
        if (!this.agentClassNamesMatcher.matches((Object)dotClassName)) {
            return false;
        }
        for (String packageName : this.hiddenAgentPackages) {
            if (!dotClassName.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    private static Class<?> tryLoad(@Nullable ClassLoader cl, String name) {
        try {
            return Class.forName(name, false, cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public URL getResource(String resourceName) {
        String className = InstrumentationModuleClassLoader.resourceToClassName(resourceName);
        if (className == null) {
            return super.getResource(resourceName);
        }
        BytecodeWithUrl injected = this.getInjectedClass(className);
        if (injected != null) {
            return injected.getUrl();
        }
        URL fromAgentCl = this.agentOrExtensionCl.getResource(resourceName);
        if (fromAgentCl != null) {
            return fromAgentCl;
        }
        if (this.instrumentedCl != null) {
            return this.instrumentedCl.getResource(resourceName);
        }
        return BOOT_LOADER.getResource(resourceName);
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        String className = InstrumentationModuleClassLoader.resourceToClassName(resourceName);
        if (className == null) {
            return super.getResources(resourceName);
        }
        URL resource = this.getResource(resourceName);
        List<Object> result = resource != null ? Collections.singletonList(resource) : Collections.emptyList();
        return Collections.enumeration(result);
    }

    @Nullable
    private static String resourceToClassName(String resourceName) {
        if (!resourceName.endsWith(".class")) {
            return null;
        }
        String className = resourceName;
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        className = className.replace('/', '.');
        className = className.substring(0, className.length() - ".class".length());
        return className;
    }

    @Nullable
    private BytecodeWithUrl getInjectedClass(String name) {
        BytecodeWithUrl alwaysInjected = ALWAYS_INJECTED_CLASSES.get(name);
        if (alwaysInjected != null) {
            return alwaysInjected;
        }
        return this.additionalInjectedClasses.get(name);
    }

    private Class<?> defineClassWithPackage(String name, byte[] bytecode) {
        try {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String packageName = name.substring(0, lastDotIndex);
                this.safeDefinePackage(packageName);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length, PROTECTION_DOMAIN);
        }
        catch (LinkageError error) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            throw error;
        }
    }

    private void safeDefinePackage(String packageName) {
        block3: {
            if (this.findPackage(packageName) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException e) {
                    if (this.findPackage(packageName) != null) break block3;
                    throw e;
                }
            }
        }
    }

    Package findPackage(String name) {
        try {
            return FIND_PACKAGE_METHOD.invoke(this, name);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private static ProtectionDomain getProtectionDomain() {
        if (System.getSecurityManager() == null) {
            return InstrumentationModuleClassLoader.class.getProtectionDomain();
        }
        return AccessController.doPrivileged(InstrumentationModuleClassLoader.class::getProtectionDomain);
    }

    private static MethodHandle getFindPackageMethod() {
        MethodType methodType = MethodType.methodType(Package.class, String.class);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(ClassLoader.class, "getDefinedPackage", methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                return lookup.findVirtual(ClassLoader.class, "getPackage", methodType);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("expected method to always exist!", ex);
            }
            catch (IllegalAccessException ex2) {
                throw new IllegalStateException("Method should be accessible from here", ex2);
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
        BOOT_LOADER = new ClassLoader(){};
        ALWAYS_INJECTED_CLASSES = Collections.singletonMap(LookupExposer.class.getName(), BytecodeWithUrl.create(LookupExposer.class).cached());
        PROTECTION_DOMAIN = InstrumentationModuleClassLoader.getProtectionDomain();
        FIND_PACKAGE_METHOD = InstrumentationModuleClassLoader.getFindPackageMethod();
        bytecodeOverride = new ConcurrentHashMap<String, byte[]>();
    }
}

