/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import java.security.ProtectionDomain;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;

public class PatchByteCodeVersionTransformer
implements AgentBuilder.Transformer {
    private static boolean isAtLeastJava7(TypeDescription typeDescription) {
        ClassFileVersion classFileVersion = typeDescription.getClassFileVersion();
        return classFileVersion != null && classFileVersion.getJavaVersion() >= 7;
    }

    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, ProtectionDomain protectionDomain) {
        if (PatchByteCodeVersionTransformer.isAtLeastJava7(typeDescription)) {
            return builder;
        }
        return builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.AbstractBase(){

            public ClassVisitor wrap(TypeDescription typeDescription, ClassVisitor classVisitor, Implementation.Context context, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fieldList, MethodList<?> methodList, int writerFlags, int readerFlags) {
                return new ClassVisitor(458752, classVisitor){

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        super.visit(51, access, name, signature, superName, interfaces);
                    }

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                        return new JSRInlinerAdapter(methodVisitor, access, name, descriptor, signature, exceptions);
                    }
                };
            }

            public int mergeWriter(int flags) {
                return flags | 2;
            }
        });
    }
}

