/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.config.AgentConfig;
import io.opentelemetry.javaagent.tooling.instrumentation.MuzzleFailureCounter;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyModuleRegistry;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import io.opentelemetry.javaagent.tooling.muzzle.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.ReferenceMatcher;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.JavaModule;

class MuzzleMatcher
implements AgentBuilder.RawMatcher {
    private static final Logger muzzleLogger = Logger.getLogger(MuzzleMatcher.class.getName());
    private final TransformSafeLogger instrumentationLogger;
    private final InstrumentationModule instrumentationModule;
    private final Level muzzleLogLevel;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Cache<ClassLoader, Boolean> matchCache = Cache.weak();
    private volatile ReferenceMatcher referenceMatcher;

    MuzzleMatcher(TransformSafeLogger instrumentationLogger, InstrumentationModule instrumentationModule, ConfigProperties config) {
        this.instrumentationLogger = instrumentationLogger;
        this.instrumentationModule = instrumentationModule;
        this.muzzleLogLevel = AgentConfig.isDebugModeEnabled(config) ? Level.WARNING : Level.FINE;
    }

    public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
        if (classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            classLoader = Utils.getBootstrapProxy();
        }
        if (this.instrumentationModule.isIndyModule()) {
            return (Boolean)this.matchCache.computeIfAbsent((Object)classLoader, cl -> {
                InstrumentationModuleClassLoader moduleCl = IndyModuleRegistry.createInstrumentationClassLoaderWithoutRegistration(this.instrumentationModule, cl);
                return this.doesMatch(moduleCl);
            });
        }
        return (Boolean)this.matchCache.computeIfAbsent((Object)classLoader, this::doesMatch);
    }

    private boolean doesMatch(ClassLoader classLoader) {
        ReferenceMatcher muzzle = this.getReferenceMatcher();
        boolean isMatch = muzzle.matches(classLoader);
        if (!isMatch) {
            MuzzleFailureCounter.inc();
            if (muzzleLogger.isLoggable(this.muzzleLogLevel)) {
                muzzleLogger.log(this.muzzleLogLevel, "Instrumentation skipped, mismatched references were found: {0} [class {1}] on {2}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
                List mismatches = muzzle.getMismatchedReferenceSources(classLoader);
                for (Mismatch mismatch : mismatches) {
                    muzzleLogger.log(this.muzzleLogLevel, "-- {0}", mismatch);
                }
            }
        } else if (this.instrumentationLogger.isLoggable(Level.FINE)) {
            this.instrumentationLogger.log(Level.FINE, "Applying instrumentation: {0} [class {1}] on {2}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
        }
        return isMatch;
    }

    private ReferenceMatcher getReferenceMatcher() {
        if (this.initialized.compareAndSet(false, true)) {
            this.referenceMatcher = ReferenceMatcher.of((InstrumentationModule)this.instrumentationModule);
        }
        return this.referenceMatcher;
    }
}

