/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.cache.weaklockfree.WeakConcurrentMapCleaner;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.AgentStarter;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.javaagent.tooling.LoggingCustomizer;
import io.opentelemetry.javaagent.tooling.NoopLoggingCustomizer;
import io.opentelemetry.javaagent.tooling.config.EarlyInitAgentConfig;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ServiceLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AgentStarterImpl
implements AgentStarter {
    private final Instrumentation instrumentation;
    private final File javaagentFile;
    private final boolean isSecurityManagerSupportEnabled;
    private ClassLoader extensionClassLoader;

    public AgentStarterImpl(Instrumentation instrumentation, File javaagentFile, boolean isSecurityManagerSupportEnabled) {
        this.instrumentation = instrumentation;
        this.javaagentFile = javaagentFile;
        this.isSecurityManagerSupportEnabled = isSecurityManagerSupportEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delayStart() {
        LaunchHelperClassFileTransformer transformer = new LaunchHelperClassFileTransformer();
        this.instrumentation.addTransformer(transformer, true);
        try {
            Class<?> clazz = Class.forName("sun.launcher.LauncherHelper", false, null);
            if (transformer.transformed) {
                boolean bl = transformer.hookInserted;
                return bl;
            }
            this.instrumentation.retransformClasses(clazz);
            boolean bl = transformer.hookInserted;
            return bl;
        }
        catch (ClassNotFoundException | UnmodifiableClassException exception) {
        }
        finally {
            this.instrumentation.removeTransformer(transformer);
        }
        return false;
    }

    public void start() {
        this.installTransformers();
        EarlyInitAgentConfig earlyConfig = EarlyInitAgentConfig.create();
        this.extensionClassLoader = this.createExtensionClassLoader(this.getClass().getClassLoader(), earlyConfig);
        String loggerImplementationName = earlyConfig.getString("otel.javaagent.logging");
        if (loggerImplementationName == null) {
            loggerImplementationName = "simple";
        }
        LoggingCustomizer loggingCustomizer = null;
        for (LoggingCustomizer customizer : ServiceLoader.load(LoggingCustomizer.class, this.extensionClassLoader)) {
            if (!customizer.name().equalsIgnoreCase(loggerImplementationName)) continue;
            loggingCustomizer = customizer;
            break;
        }
        if (loggingCustomizer == null) {
            AgentStarterImpl.logUnrecognizedLoggerImplWarning(loggerImplementationName);
            loggingCustomizer = new NoopLoggingCustomizer();
        }
        Throwable startupError = null;
        try {
            loggingCustomizer.init(earlyConfig);
            earlyConfig.logEarlyConfigErrorsIfAny();
            AgentInstaller.installBytebuddyAgent(this.instrumentation, this.extensionClassLoader, earlyConfig);
            WeakConcurrentMapCleaner.start();
            if (System.getSecurityManager() != null) {
                Context.current();
            }
        }
        catch (Throwable t) {
            startupError = t;
        }
        if (startupError == null) {
            loggingCustomizer.onStartupSuccess();
        } else {
            loggingCustomizer.onStartupFailure(startupError);
        }
    }

    private void installTransformers() {
        InetAddressClassFileTransformer transformer = new InetAddressClassFileTransformer();
        this.instrumentation.addTransformer(transformer, true);
    }

    private static void logUnrecognizedLoggerImplWarning(String loggerImplementationName) {
        System.err.println("Unrecognized value of 'otel.javaagent.logging': '" + loggerImplementationName + "'. The agent will use the no-op implementation.");
    }

    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    private ClassLoader createExtensionClassLoader(ClassLoader agentClassLoader, EarlyInitAgentConfig earlyConfig) {
        return ExtensionClassLoader.getInstance(agentClassLoader, this.javaagentFile, this.isSecurityManagerSupportEnabled, earlyConfig);
    }

    private static class LaunchHelperClassFileTransformer
    implements ClassFileTransformer {
        boolean hookInserted = false;
        boolean transformed = false;

        private LaunchHelperClassFileTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (!"sun/launcher/LauncherHelper".equals(className)) {
                return null;
            }
            this.transformed = true;
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(cr, 0);
            ClassVisitor cv = new ClassVisitor(589824, (ClassVisitor)cw){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if ("checkAndLoadMain".equals(name)) {
                        return new MethodVisitor(this.api, mv){

                            public void visitCode() {
                                super.visitCode();
                                hookInserted = true;
                                this.mv.visitMethodInsn(184, Type.getInternalName(AgentInitializer.class), "delayedStartHook", "()V", false);
                            }
                        };
                    }
                    return mv;
                }
            };
            cr.accept(cv, 0);
            return this.hookInserted ? cw.toByteArray() : null;
        }
    }

    private static class InetAddressClassFileTransformer
    implements ClassFileTransformer {
        boolean hookInserted = false;

        private InetAddressClassFileTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (!"java/net/InetAddress".equals(className)) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(cr, 0);
            ClassVisitor cv = new ClassVisitor(589824, (ClassVisitor)cw){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if (!"resolver".equals(name)) {
                        return mv;
                    }
                    return new MethodVisitor(this.api, mv){

                        public void visitMethodInsn(int opcode, String ownerClassName, String methodName, String descriptor, boolean isInterface) {
                            super.visitMethodInsn(opcode, ownerClassName, methodName, descriptor, isInterface);
                            if ("jdk/internal/misc/VM".equals(ownerClassName) && "isBooted".equals(methodName)) {
                                super.visitMethodInsn(184, Type.getInternalName(AgentInitializer.class), "isAgentStarted", "(Z)Z", false);
                                hookInserted = true;
                            }
                        }
                    };
                }
            };
            cr.accept(cv, 0);
            return this.hookInserted ? cw.toByteArray() : null;
        }
    }
}

