/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

final class GeneratedVirtualFieldNames {
    static final String DYNAMIC_CLASSES_PACKAGE = "io.opentelemetry.javaagent.bootstrap.field.";

    private GeneratedVirtualFieldNames() {
    }

    public static boolean isVirtualFieldInterfaceName(String className) {
        return className.startsWith("io.opentelemetry.javaagent.bootstrap.field.VirtualFieldAccessor$");
    }

    static String getVirtualFieldImplementationClassName(String typeName, String fieldTypeName) {
        return "io.opentelemetry.javaagent.bootstrap.field.VirtualFieldImpl$" + GeneratedVirtualFieldNames.sanitizeClassName(typeName) + "$" + GeneratedVirtualFieldNames.sanitizeClassName(fieldTypeName);
    }

    static String getFieldAccessorInterfaceName(String typeName, String fieldTypeName) {
        return "io.opentelemetry.javaagent.bootstrap.field.VirtualFieldAccessor$" + GeneratedVirtualFieldNames.sanitizeClassName(typeName) + "$" + GeneratedVirtualFieldNames.sanitizeClassName(fieldTypeName);
    }

    static String getRealFieldName(String typeName, String fieldTypeName) {
        return "__opentelemetryVirtualField$" + GeneratedVirtualFieldNames.sanitizeClassName(typeName) + "$" + GeneratedVirtualFieldNames.sanitizeClassName(fieldTypeName);
    }

    static String getRealGetterName(String typeName, String fieldTypeName) {
        return "__get" + GeneratedVirtualFieldNames.getRealFieldName(typeName, fieldTypeName);
    }

    static String getRealSetterName(String typeName, String fieldTypeName) {
        return "__set" + GeneratedVirtualFieldNames.getRealFieldName(typeName, fieldTypeName);
    }

    private static String sanitizeClassName(String className) {
        if ((className = className.replace('.', '$')).endsWith("[]")) {
            className = className.replace('[', '_').replace(']', '_');
        }
        return className;
    }
}

