/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.tooling.util.Trie;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

final class TrieImpl<V>
implements Trie<V> {
    private final Node<V> root;

    private TrieImpl(Node<V> root) {
        this.root = root;
    }

    @Override
    public V getOrDefault(CharSequence str, V defaultValue) {
        Node<V> node = this.root;
        V lastMatchedValue = defaultValue;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            Node<V> next = node.getNext(c);
            if (next == null) {
                return lastMatchedValue;
            }
            node = next;
            lastMatchedValue = next.value != null ? next.value : lastMatchedValue;
        }
        return lastMatchedValue;
    }

    static final class Node<V> {
        final char[] chars;
        final Node<V>[] children;
        final V value;

        Node(char[] chars, Node<V>[] children, V value) {
            this.chars = chars;
            this.children = children;
            this.value = value;
        }

        @Nullable
        Node<V> getNext(char c) {
            int index = Arrays.binarySearch(this.chars, c);
            if (index < 0) {
                return null;
            }
            return this.children[index];
        }
    }

    static final class NodeBuilder<V> {
        final Map<Character, NodeBuilder<V>> children = new HashMap<Character, NodeBuilder<V>>();
        V value;

        NodeBuilder() {
        }

        Node<V> build() {
            int size = this.children.size();
            char[] chars = new char[size];
            Node[] nodes = new Node[size];
            int i = 0;
            Iterator it = this.children.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                chars[i] = ((Character)e.getKey()).charValue();
                nodes[i++] = ((NodeBuilder)e.getValue()).build();
            }
            return new Node<V>(chars, nodes, this.value);
        }
    }

    static final class BuilderImpl<V>
    implements Trie.Builder<V> {
        private final NodeBuilder<V> root = new NodeBuilder();

        BuilderImpl() {
        }

        @Override
        @CanIgnoreReturnValue
        public Trie.Builder<V> put(CharSequence str, V value) {
            this.put(this.root, str, 0, value);
            return this;
        }

        private void put(NodeBuilder<V> node, CharSequence str, int i, V value) {
            if (str.length() == i) {
                node.value = value;
                return;
            }
            char c = str.charAt(i);
            NodeBuilder next = node.children.computeIfAbsent(Character.valueOf(c), k -> new NodeBuilder());
            this.put(next, str, i + 1, value);
        }

        @Override
        public Trie<V> build() {
            return new TrieImpl(this.root.build());
        }
    }
}

