/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.Utils;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class OtelEncodingUtils {
    static final int LONG_BYTES = 8;
    static final int BYTE_BASE16 = 2;
    static final int LONG_BASE16 = 16;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final char[] ENCODING = OtelEncodingUtils.buildEncodingArray();
    private static final byte[] DECODING = OtelEncodingUtils.buildDecodingArray();

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    public static long longFromBase16String(CharSequence chars, int offset) {
        return ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)OtelEncodingUtils.byteFromBase16(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    public static void longToBase16String(long value, char[] dest, int destOffset) {
        OtelEncodingUtils.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        OtelEncodingUtils.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        OtelEncodingUtils.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        OtelEncodingUtils.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        OtelEncodingUtils.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        OtelEncodingUtils.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        OtelEncodingUtils.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        OtelEncodingUtils.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    public static byte[] bytesFromBase16(CharSequence value, int length) {
        byte[] result = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            result[i / 2] = OtelEncodingUtils.byteFromBase16(value.charAt(i), value.charAt(i + 1));
        }
        return result;
    }

    public static void bytesToBase16(byte[] bytes, char[] dest, int length) {
        for (int i = 0; i < length; ++i) {
            OtelEncodingUtils.byteToBase16(bytes[i], dest, i * 2);
        }
    }

    public static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    public static byte byteFromBase16(char first, char second) {
        Utils.checkArgument(first < '\u0080' && DECODING[first] != -1, "invalid character " + first);
        Utils.checkArgument(second < '\u0080' && DECODING[second] != -1, "invalid character " + second);
        int decoded = DECODING[first] << 4 | DECODING[second];
        return (byte)decoded;
    }

    public static boolean isValidBase16String(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char b = value.charAt(i);
            if (OtelEncodingUtils.isValidBase16Character(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBase16Character(char b) {
        return '0' <= b && b <= '9' || 'a' <= b && b <= 'f';
    }

    private OtelEncodingUtils() {
    }
}

