/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.server;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.server.ServerSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.server.ServerSpanNameSupplier;
import io.opentelemetry.javaagent.shaded.instrumentation.api.server.ServerSpanNameTwoArgSupplier;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import javax.annotation.Nullable;

public final class ServerSpanNaming {
    private static final ContextKey<ServerSpanNaming> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-span-naming-key");
    private volatile Source updatedBySource;
    private volatile int nameLength;

    public static <REQUEST> ContextCustomizer<REQUEST> get() {
        return (context, request, startAttributes) -> {
            if (context.get(CONTEXT_KEY) != null) {
                return context;
            }
            return context.with(CONTEXT_KEY, new ServerSpanNaming(Source.CONTAINER));
        };
    }

    private ServerSpanNaming(Source initialSource) {
        this.updatedBySource = initialSource;
    }

    public static <T> void updateServerSpanName(Context context, Source source, ServerSpanNameSupplier<T> serverSpanName, T arg1) {
        ServerSpanNaming.updateServerSpanName(context, source, OneArgAdapter.getInstance(), arg1, serverSpanName);
    }

    public static <T, U> void updateServerSpanName(Context context, Source source, ServerSpanNameTwoArgSupplier<T, U> serverSpanName, T arg1, U arg2) {
        String name;
        boolean onlyIfBetterName;
        Span serverSpan = ServerSpan.fromContextOrNull(context);
        if (serverSpan == null || !serverSpan.isRecording()) {
            return;
        }
        ServerSpanNaming serverSpanNaming = context.get(CONTEXT_KEY);
        if (serverSpanNaming == null) {
            String name2 = serverSpanName.get(context, arg1, arg2);
            if (name2 != null && !name2.isEmpty()) {
                serverSpan.updateName(name2);
            }
            return;
        }
        boolean bl = onlyIfBetterName = !source.useFirst && source.order == serverSpanNaming.updatedBySource.order;
        if (!(source.order <= serverSpanNaming.updatedBySource.order && !onlyIfBetterName || (name = serverSpanName.get(context, arg1, arg2)) == null || name.isEmpty() || onlyIfBetterName && !serverSpanNaming.isBetterName(name))) {
            serverSpan.updateName(name);
            serverSpanNaming.updatedBySource = source;
            serverSpanNaming.nameLength = name.length();
        }
    }

    private boolean isBetterName(String name) {
        return name.length() > this.nameLength;
    }

    private static class OneArgAdapter<T>
    implements ServerSpanNameTwoArgSupplier<T, ServerSpanNameSupplier<T>> {
        private static final OneArgAdapter<Object> INSTANCE = new OneArgAdapter();

        private OneArgAdapter() {
        }

        static <T> OneArgAdapter<T> getInstance() {
            return INSTANCE;
        }

        @Override
        @Nullable
        public String get(Context context, T arg, ServerSpanNameSupplier<T> serverSpanNameSupplier) {
            return serverSpanNameSupplier.get(context, arg);
        }
    }

    public static enum Source {
        CONTAINER(1),
        FILTER(2, false),
        SERVLET(3),
        CONTROLLER(4),
        NESTED_CONTROLLER(5, false);

        private final int order;
        private final boolean useFirst;

        private Source(int order) {
            this(order, true);
        }

        private Source(int order, boolean useFirst) {
            this.order = order;
            this.useFirst = useFirst;
        }
    }
}

