/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private final AttributeKey<String> dbTableAttribute;

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> dbTableAttribute) {
        super(getter);
        this.dbTableAttribute = dbTableAttribute;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        SqlStatementInfo sanitizedStatement = SqlStatementSanitizer.sanitize(((SqlClientAttributesGetter)this.getter).rawStatement(request));
        this.set(attributes, SemanticAttributes.DB_STATEMENT, sanitizedStatement.getFullStatement());
        this.set(attributes, SemanticAttributes.DB_OPERATION, sanitizedStatement.getOperation());
        this.set(attributes, this.dbTableAttribute, sanitizedStatement.getTable());
    }
}

