/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpMessageBodySizeUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpMetricsAdvice;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.logging.Level;

public final class HttpServerExperimentalMetrics
implements OperationListener {
    private static final ContextKey<Attributes> HTTP_SERVER_EXPERIMENTAL_METRICS_START_ATTRIBUTES = ContextKey.named("http-server-experimental-metrics-start-attributes");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerExperimentalMetrics.class.getName());
    private final LongUpDownCounter activeRequests;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpServerExperimentalMetrics::new;
    }

    private HttpServerExperimentalMetrics(Meter meter) {
        LongUpDownCounterBuilder activeRequestsBuilder = meter.upDownCounterBuilder("http.server.active_requests").setUnit("{requests}").setDescription("Number of active HTTP server requests.");
        HttpMetricsAdvice.applyServerActiveRequestsAdvice(activeRequestsBuilder);
        this.activeRequests = activeRequestsBuilder.build();
        LongHistogramBuilder requestSizeBuilder = meter.histogramBuilder("http.server.request.size").setUnit("By").setDescription("Size of HTTP server request bodies.").ofLongs();
        HttpMetricsAdvice.applyServerRequestSizeAdvice(requestSizeBuilder);
        this.requestSize = requestSizeBuilder.build();
        LongHistogramBuilder responseSizeBuilder = meter.histogramBuilder("http.server.response.size").setUnit("By").setDescription("Size of HTTP server response bodies.").ofLongs();
        HttpMetricsAdvice.applyServerRequestSizeAdvice(responseSizeBuilder);
        this.responseSize = responseSizeBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, startAttributes, context);
        return context.with(HTTP_SERVER_EXPERIMENTAL_METRICS_START_ATTRIBUTES, startAttributes);
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        Attributes startAttributes = context.get(HTTP_SERVER_EXPERIMENTAL_METRICS_START_ATTRIBUTES);
        if (startAttributes == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.activeRequests.add(-1L, startAttributes, context);
        Attributes sizeAttributes = startAttributes.toBuilder().putAll(endAttributes).build();
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, startAttributes);
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize, sizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, startAttributes)) != null) {
            this.responseSize.record(responseBodySize, sizeAttributes, context);
        }
    }
}

