/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.common.LabelsBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

@UnstableApi
public final class HttpServerMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named("http-server-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(HttpServerMetrics.class);
    private final LongUpDownCounter activeRequests;
    private final DoubleValueRecorder duration;

    @UnstableApi
    public static RequestMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.longUpDownCounterBuilder("http.server.active_requests").setUnit("requests").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.duration = meter.doubleValueRecorderBuilder("http.server.duration").setUnit("milliseconds").setDescription("The duration of the inbound HTTP request").build();
    }

    @Override
    public Context start(Context context, Attributes requestAttributes) {
        long startTimeNanos = System.nanoTime();
        Labels activeRequestLabels = HttpServerMetrics.activeRequestLabels(requestAttributes);
        Labels durationLabels = HttpServerMetrics.durationLabels(requestAttributes);
        this.activeRequests.add(1L, activeRequestLabels);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, new AutoValue_HttpServerMetrics_State(activeRequestLabels, durationLabels, startTimeNanos));
    }

    @Override
    public void end(Context context, Attributes responseAttributes) {
        State state = context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot reset HTTP request metrics.", (Object)context);
            return;
        }
        this.activeRequests.add(-1L, state.activeRequestLabels());
        this.duration.record((double)(System.nanoTime() - state.startTimeNanos()) / NANOS_PER_MS, state.durationLabels());
    }

    private static Labels activeRequestLabels(Attributes attributes) {
        LabelsBuilder labels = Labels.builder();
        attributes.forEach((key, value) -> {
            if (key.getType() != AttributeType.STRING) {
                return;
            }
            switch (key.getKey()) {
                case "http.method": 
                case "http.host": 
                case "http.scheme": 
                case "http.flavor": 
                case "http.server_name": {
                    labels.put(key.getKey(), (String)value);
                    break;
                }
            }
        });
        return labels.build();
    }

    private static Labels durationLabels(Attributes attributes) {
        LabelsBuilder labels = Labels.builder();
        attributes.forEach((key, value) -> {
            switch (key.getKey()) {
                case "http.method": 
                case "http.host": 
                case "http.scheme": 
                case "http.flavor": 
                case "http.server_name": 
                case "net.host.name": {
                    if (!(value instanceof String)) break;
                    labels.put(key.getKey(), (String)value);
                    break;
                }
                case "http.status_code": 
                case "net.host.port": {
                    if (!(value instanceof Long)) break;
                    labels.put(key.getKey(), Long.toString((Long)value));
                    break;
                }
            }
        });
        return labels.build();
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Labels activeRequestLabels();

        abstract Labels durationLabels();

        abstract long startTimeNanos();
    }
}

