/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ClientSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ConsumerSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ServerSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapSetter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class BaseTracer {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final Tracer tracer;
    private final ContextPropagators propagators;

    @Deprecated
    protected BaseTracer() {
        this(GlobalOpenTelemetry.get());
    }

    protected BaseTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
        this.propagators = openTelemetry.getPropagators();
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return InstrumentationVersion.VERSION;
    }

    public final boolean shouldStartSpan(Context context, SpanKind proposedKind) {
        boolean suppressed = false;
        switch (proposedKind) {
            case CLIENT: {
                suppressed = ClientSpan.exists(context);
                break;
            }
            case SERVER: 
            case CONSUMER: {
                suppressed = ServerSpan.exists(context) || ConsumerSpan.exists(context);
                break;
            }
        }
        if (suppressed) {
            supportability.recordSuppressedSpan(proposedKind, this.getInstrumentationName());
        }
        return !suppressed;
    }

    public Context startSpan(String spanName) {
        return this.startSpan(spanName, SpanKind.INTERNAL);
    }

    public Context startSpan(String spanName, SpanKind kind) {
        return this.startSpan(Context.current(), spanName, kind);
    }

    public Context startSpan(Context parentContext, String spanName, SpanKind kind) {
        Span span = this.spanBuilder(parentContext, spanName, kind).startSpan();
        return parentContext.with(span);
    }

    protected final SpanBuilder spanBuilder(Context parentContext, String spanName, SpanKind kind) {
        return this.tracer.spanBuilder(spanName).setSpanKind(kind).setParent(parentContext);
    }

    protected final Context withClientSpan(Context parentContext, Span span) {
        return ClientSpan.with(parentContext.with(span), span);
    }

    protected final Context withServerSpan(Context parentContext, Span span) {
        return ServerSpan.with(parentContext.with(span), span);
    }

    protected final Context withConsumerSpan(Context parentContext, Span span) {
        return ConsumerSpan.with(parentContext.with(span), span);
    }

    public void end(Context context) {
        this.end(context, -1L);
    }

    public void end(Context context, long endTimeNanos) {
        Span span = Span.fromContext(context);
        if (endTimeNanos > 0L) {
            span.end(endTimeNanos, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, long endTimeNanos) {
        this.onException(context, throwable);
        this.end(context, endTimeNanos);
    }

    public void onException(Context context, Throwable throwable) {
        Span span = Span.fromContext(context);
        span.setStatus(StatusCode.ERROR);
        span.recordException(this.unwrapThrowable(throwable));
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        if (throwable.getCause() != null && (throwable instanceof ExecutionException || throwable instanceof CompletionException || throwable instanceof InvocationTargetException || throwable instanceof UndeclaredThrowableException)) {
            return this.unwrapThrowable(throwable.getCause());
        }
        return throwable;
    }

    public <C> Context extract(C carrier, TextMapGetter<C> getter) {
        ContextPropagationDebug.debugContextLeakIfEnabled();
        Context parent = Context.current();
        if (Span.fromContextOrNull(parent) != null) {
            parent = Context.root();
        }
        return this.propagators.getTextMapPropagator().extract(parent, carrier, getter);
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        this.propagators.getTextMapPropagator().inject(context, carrier, setter);
    }
}

