/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.caching;

import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.CaffeineCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.WeakLockFreeCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine.cache.Caffeine;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CacheBuilder {
    private static final long UNSET = -1L;
    private boolean weakKeys;
    private boolean weakValues;
    private long maximumSize = -1L;
    private @Nullable Executor executor = null;

    public CacheBuilder setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public CacheBuilder setWeakKeys() {
        this.weakKeys = true;
        return this;
    }

    public CacheBuilder setWeakValues() {
        this.weakValues = true;
        return this;
    }

    CacheBuilder setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public <K, V> Cache<K, V> build() {
        if (this.weakKeys && !this.weakValues && this.maximumSize == -1L) {
            return new WeakLockFreeCache();
        }
        Caffeine<Object, Object> caffeine = Caffeine.newBuilder();
        if (this.weakKeys) {
            caffeine.weakKeys();
        }
        if (this.weakValues) {
            caffeine.weakValues();
        }
        if (this.maximumSize != -1L) {
            caffeine.maximumSize(this.maximumSize);
        }
        if (this.executor != null) {
            caffeine.executor(this.executor);
        } else {
            caffeine.executor(Runnable::run);
        }
        io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine.cache.Cache delegate = caffeine.build();
        return new CaffeineCache(delegate);
    }

    CacheBuilder() {
    }
}

