/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public final class PropagatedContext {
    private static final Logger logger = LoggerFactory.getLogger(PropagatedContext.class);
    private static final AtomicReferenceFieldUpdater<PropagatedContext, Context> contextUpdater = AtomicReferenceFieldUpdater.newUpdater(PropagatedContext.class, Context.class, "context");
    static final Supplier<PropagatedContext> FACTORY = PropagatedContext::new;
    private volatile Context context;

    private PropagatedContext() {
    }

    void setContext(Context context) {
        Context currentPropagatedContext;
        boolean result = contextUpdater.compareAndSet(this, null, context);
        if (!result && (currentPropagatedContext = contextUpdater.get(this)) != context && logger.isDebugEnabled()) {
            logger.debug("Failed to propagate context because previous propagated context is already set {}: new: {}, old: {}", this, context, currentPropagatedContext);
        }
    }

    public void clear() {
        contextUpdater.set(this, null);
    }

    Context getAndClear() {
        return contextUpdater.getAndSet(this, null);
    }
}

