/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api;

import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ContextStore<K, C> {
    public C get(K var1);

    public void put(K var1, C var2);

    public C putIfAbsent(K var1, C var2);

    public C putIfAbsent(K var1, Supplier<C> var2);

    default public Cache<K, C> asCache() {
        return new Cache<K, C>(){

            @Override
            public C computeIfAbsent(K key, Function<? super K, ? extends C> mappingFunction) {
                return ContextStore.this.putIfAbsent(key, () -> mappingFunction.apply((Object)key));
            }

            @Override
            public C get(K key) {
                return ContextStore.this.get(key);
            }

            @Override
            public void put(K key, C value) {
                ContextStore.this.put(key, value);
            }

            @Override
            public void remove(K key) {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }
}

