/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.field.VirtualField;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class RuntimeVirtualFieldSupplier {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeVirtualFieldSupplier.class);
    private static final VirtualFieldSupplier DEFAULT;
    private static volatile VirtualFieldSupplier instance;

    public static void set(VirtualFieldSupplier virtualFieldSupplier) {
        if (instance != DEFAULT) {
            logger.warn("Runtime VirtualField supplier has already been set up, further set() calls are ignored");
            return;
        }
        instance = virtualFieldSupplier;
    }

    public static VirtualFieldSupplier get() {
        return instance;
    }

    private RuntimeVirtualFieldSupplier() {
    }

    static {
        instance = DEFAULT = new CacheBasedVirtualFieldSupplier();
    }

    private static final class CacheBasedVirtualField<T, F>
    extends VirtualField<T, F> {
        private final Cache<T, F> cache = Cache.builder().setWeakKeys().build();

        private CacheBasedVirtualField() {
        }

        @Override
        @Nullable
        public F get(T object) {
            return this.cache.get(object);
        }

        @Override
        public void set(T object, @Nullable F fieldValue) {
            if (fieldValue == null) {
                this.cache.remove(object);
            } else {
                this.cache.put(object, fieldValue);
            }
        }
    }

    private static final class CacheBasedVirtualFieldSupplier
    extends ClassValue<Map<Class<?>, VirtualField<?, ?>>>
    implements VirtualFieldSupplier {
        private CacheBasedVirtualFieldSupplier() {
        }

        @Override
        public <U extends T, T, F> VirtualField<U, F> find(Class<T> type, Class<F> fieldType) {
            return ((Map)this.get(type)).computeIfAbsent(fieldType, k -> new CacheBasedVirtualField());
        }

        @Override
        protected Map<Class<?>, VirtualField<?, ?>> computeValue(Class<?> type) {
            return new ConcurrentHashMap();
        }
    }

    public static interface VirtualFieldSupplier {
        public <U extends T, T, F> VirtualField<U, F> find(Class<T> var1, Class<F> var2);
    }
}

