/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AutoValue_CapturedHttpHeaders;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@AutoValue
public abstract class CapturedHttpHeaders {
    private static final CapturedHttpHeaders EMPTY = CapturedHttpHeaders.create(Collections.emptyList(), Collections.emptyList());

    public static CapturedHttpHeaders empty() {
        return EMPTY;
    }

    public static CapturedHttpHeaders client(Config config) {
        return CapturedHttpHeaders.create(config.getList("otel.instrumentation.common.experimental.capture-http-headers.client.request"), config.getList("otel.instrumentation.common.experimental.capture-http-headers.client.response"));
    }

    public static CapturedHttpHeaders server(Config config) {
        return CapturedHttpHeaders.create(config.getList("otel.instrumentation.common.experimental.capture-http-headers.server.request"), config.getList("otel.instrumentation.common.experimental.capture-http-headers.server.response"));
    }

    public static CapturedHttpHeaders create(List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        return new AutoValue_CapturedHttpHeaders(CapturedHttpHeaders.lowercase(capturedRequestHeaders), CapturedHttpHeaders.lowercase(capturedResponseHeaders));
    }

    private static List<String> lowercase(List<String> names) {
        return names.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public abstract List<String> requestHeaders();

    public abstract List<String> responseHeaders();

    CapturedHttpHeaders() {
    }
}

