/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support;

import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.AttributeBinding;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.AttributeBindingFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.AttributeBindings;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodArgumentsExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.cache.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.AttributeSetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.annotation.Nullable;

public final class MethodSpanAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final MethodExtractor<REQUEST> methodExtractor;
    private final MethodArgumentsExtractor<REQUEST> methodArgumentsExtractor;
    private final Cache<Method, AttributeBindings> cache;
    private final ParameterAttributeNamesExtractor parameterAttributeNamesExtractor;

    public static <REQUEST, RESPONSE> MethodSpanAttributesExtractor<REQUEST, RESPONSE> newInstance(MethodExtractor<REQUEST> methodExtractor, ParameterAttributeNamesExtractor parameterAttributeNamesExtractor, MethodArgumentsExtractor<REQUEST> methodArgumentsExtractor) {
        return new MethodSpanAttributesExtractor<REQUEST, RESPONSE>(methodExtractor, parameterAttributeNamesExtractor, methodArgumentsExtractor, new MethodCache<AttributeBindings>());
    }

    MethodSpanAttributesExtractor(MethodExtractor<REQUEST> methodExtractor, ParameterAttributeNamesExtractor parameterAttributeNamesExtractor, MethodArgumentsExtractor<REQUEST> methodArgumentsExtractor, Cache<Method, AttributeBindings> cache) {
        this.methodExtractor = methodExtractor;
        this.methodArgumentsExtractor = methodArgumentsExtractor;
        this.parameterAttributeNamesExtractor = parameterAttributeNamesExtractor;
        this.cache = cache;
    }

    @Override
    public void onStart(AttributesBuilder attributes, REQUEST request) {
        Method method = this.methodExtractor.extract(request);
        AttributeBindings bindings = this.cache.computeIfAbsent(method, this::bind);
        if (!bindings.isEmpty()) {
            Object[] args = this.methodArgumentsExtractor.extract(request);
            bindings.apply(attributes::put, args);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }

    private AttributeBindings bind(Method method) {
        AttributeBindings bindings = EmptyAttributeBindings.INSTANCE;
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return bindings;
        }
        String[] attributeNames = this.parameterAttributeNamesExtractor.extract(method, parameters);
        if (attributeNames.length != parameters.length) {
            return bindings;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String attributeName = attributeNames[i];
            if (attributeName == null || attributeName.isEmpty()) continue;
            bindings = new CombinedAttributeBindings(bindings, i, AttributeBindingFactory.createBinding(attributeName, parameter.getParameterizedType()));
        }
        return bindings;
    }

    private static final class CombinedAttributeBindings
    implements AttributeBindings {
        private final AttributeBindings parent;
        private final int index;
        private final AttributeBinding binding;

        public CombinedAttributeBindings(AttributeBindings parent, int index, AttributeBinding binding) {
            this.parent = parent;
            this.index = index;
            this.binding = binding;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void apply(AttributeSetter setter, Object[] args) {
            Object arg;
            this.parent.apply(setter, args);
            if (args != null && args.length > this.index && (arg = args[this.index]) != null) {
                this.binding.apply(setter, arg);
            }
        }
    }

    protected static enum EmptyAttributeBindings implements AttributeBindings
    {
        INSTANCE;


        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void apply(AttributeSetter setter, Object[] args) {
        }
    }
}

