/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.CapturedHttpHeadersUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpStatusCodeConverter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.internal.HttpAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.NetworkAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.SemanticAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

abstract class HttpCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends HttpCommonAttributesGetter<REQUEST, RESPONSE> & NetworkAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final GETTER getter;
    private final HttpStatusCodeConverter statusCodeConverter;
    private final List<String> capturedRequestHeaders;
    private final List<String> capturedResponseHeaders;
    private final Set<String> knownMethods;

    HttpCommonAttributesExtractor(GETTER getter, HttpStatusCodeConverter statusCodeConverter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Set<String> knownMethods) {
        this.getter = getter;
        this.statusCodeConverter = statusCodeConverter;
        this.capturedRequestHeaders = CapturedHttpHeadersUtil.lowercase(capturedRequestHeaders);
        this.capturedResponseHeaders = CapturedHttpHeadersUtil.lowercase(capturedResponseHeaders);
        this.knownMethods = new HashSet<String>(knownMethods);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String method = this.getter.getHttpRequestMethod(request);
        if (method == null || this.knownMethods.contains(method)) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_REQUEST_METHOD, method);
        } else {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_REQUEST_METHOD, "_OTHER");
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_REQUEST_METHOD_ORIGINAL, method);
        }
        for (String name : this.capturedRequestHeaders) {
            List<String> values = this.getter.getHttpRequestHeader(request, name);
            if (values.isEmpty()) continue;
            AttributesExtractorUtil.internalSet(attributes, CapturedHttpHeadersUtil.requestAttributeKey(name), values);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer statusCode = null;
        if (response != null) {
            statusCode = this.getter.getHttpResponseStatusCode(request, response, error);
            if (statusCode != null && statusCode > 0) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, Long.valueOf(statusCode.intValue()));
            }
            for (String name : this.capturedResponseHeaders) {
                List<String> values = this.getter.getHttpResponseHeader(request, response, name);
                if (values.isEmpty()) continue;
                AttributesExtractorUtil.internalSet(attributes, CapturedHttpHeadersUtil.responseAttributeKey(name), values);
            }
        }
        String errorType = null;
        if (statusCode != null && statusCode > 0) {
            if (this.statusCodeConverter.isError(statusCode)) {
                errorType = statusCode.toString();
            }
        } else {
            errorType = this.getter.getErrorType(request, response, error);
            if (errorType == null && error != null) {
                errorType = error.getClass().getName();
            }
            if (errorType == null) {
                errorType = "_OTHER";
            }
        }
        AttributesExtractorUtil.internalSet(attributes, HttpAttributes.ERROR_TYPE, errorType);
        String protocolName = HttpCommonAttributesExtractor.lowercaseStr(((NetworkAttributesGetter)this.getter).getNetworkProtocolName(request, response));
        String protocolVersion = HttpCommonAttributesExtractor.lowercaseStr(((NetworkAttributesGetter)this.getter).getNetworkProtocolVersion(request, response));
        if (protocolVersion != null) {
            if (!"http".equals(protocolName)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_PROTOCOL_NAME, protocolName);
            }
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_PROTOCOL_VERSION, protocolVersion);
        }
    }

    @Nullable
    static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }

    @Nullable
    private static String lowercaseStr(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ROOT);
    }
}

