/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.messaging;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.messaging.AutoValue_MessagingProducerMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.messaging.MessagingMetricsAdvice;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.OperationMetricsUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class MessagingProducerMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> MESSAGING_PRODUCER_METRICS_STATE = ContextKey.named("messaging-producer-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(MessagingProducerMetrics.class.getName());
    private final DoubleHistogram publishDurationHistogram;

    private MessagingProducerMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("messaging.publish.duration").setDescription("Measures the duration of publish operation.").setExplicitBucketBoundariesAdvice(MessagingMetricsAdvice.DURATION_SECONDS_BUCKETS).setUnit("s");
        MessagingMetricsAdvice.applyPublishDurationAdvice(durationBuilder);
        this.publishDurationHistogram = durationBuilder.build();
    }

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("messaging producer", MessagingProducerMetrics::new);
    }

    @Override
    @CanIgnoreReturnValue
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(MESSAGING_PRODUCER_METRICS_STATE, new AutoValue_MessagingProducerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(MESSAGING_PRODUCER_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record produce publish metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.publishDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

