/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.trace.BigendianEncoding;
import io.opentelemetry.api.trace.ImmutableSpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanContext {
    public static SpanContext getInvalid() {
        return ImmutableSpanContext.getInvalid();
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, byte traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, false);
    }

    public static SpanContext createFromRemoteParent(String traceIdHex, String spanIdHex, byte traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, true);
    }

    public String getTraceIdAsHexString();

    default public byte[] getTraceIdBytes() {
        return TraceId.bytesFromHex(this.getTraceIdAsHexString(), 0);
    }

    public String getSpanIdAsHexString();

    default public byte[] getSpanIdBytes() {
        return SpanId.bytesFromHex(this.getSpanIdAsHexString(), 0);
    }

    default public boolean isSampled() {
        return (this.getTraceFlags() & 1) == 1;
    }

    public byte getTraceFlags();

    default public void copyTraceFlagsHexTo(char[] dest, int destOffset) {
        BigendianEncoding.byteToBase16String(this.getTraceFlags(), dest, destOffset);
    }

    public TraceState getTraceState();

    default public boolean isValid() {
        return TraceId.isValid(this.getTraceIdAsHexString()) && SpanId.isValid(this.getSpanIdAsHexString());
    }

    public boolean isRemote();
}

