/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.spi.MeterProviderFactory;
import io.opentelemetry.api.spi.OpenTelemetryFactory;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.spi.TracerProviderFactory;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.DefaultContextPropagators;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultOpenTelemetry
implements OpenTelemetry {
    private static final Object mutex = new Object();
    @Nullable
    private static volatile OpenTelemetry globalOpenTelemetry;
    private final TracerProvider tracerProvider;
    private final MeterProvider meterProvider;
    private final ContextPropagators propagators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpenTelemetry getGlobalOpenTelemetry() {
        if (globalOpenTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                if (globalOpenTelemetry == null) {
                    OpenTelemetryFactory openTelemetryFactory = DefaultOpenTelemetry.loadSpi(OpenTelemetryFactory.class);
                    globalOpenTelemetry = openTelemetryFactory != null ? openTelemetryFactory.create() : DefaultOpenTelemetry.builder().build();
                }
            }
        }
        return globalOpenTelemetry;
    }

    static void setGlobalOpenTelemetry(OpenTelemetry openTelemetry) {
        globalOpenTelemetry = openTelemetry;
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    @Override
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    @Override
    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    DefaultOpenTelemetry(TracerProvider tracerProvider, MeterProvider meterProvider, ContextPropagators propagators) {
        this.tracerProvider = tracerProvider;
        this.meterProvider = meterProvider;
        this.propagators = propagators;
    }

    @Nullable
    private static <T> T loadSpi(Class<T> providerClass) {
        String specifiedProvider = System.getProperty(providerClass.getName());
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        for (T provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }

    static void reset() {
        globalOpenTelemetry = null;
    }

    public Builder toBuilder() {
        return new Builder().setTracerProvider(this.tracerProvider).setMeterProvider(this.meterProvider).setPropagators(this.propagators);
    }

    static class Builder
    implements OpenTelemetry.Builder<Builder> {
        private ContextPropagators propagators = DefaultContextPropagators.builder().build();
        private TracerProvider tracerProvider;
        private MeterProvider meterProvider;

        Builder() {
        }

        @Override
        public Builder setTracerProvider(TracerProvider tracerProvider) {
            Objects.requireNonNull(tracerProvider, "tracerProvider");
            this.tracerProvider = tracerProvider;
            return this;
        }

        @Override
        public Builder setMeterProvider(MeterProvider meterProvider) {
            Objects.requireNonNull(meterProvider, "meterProvider");
            this.meterProvider = meterProvider;
            return this;
        }

        @Override
        public Builder setPropagators(ContextPropagators propagators) {
            Objects.requireNonNull(propagators, "propagators");
            this.propagators = propagators;
            return this;
        }

        @Override
        public OpenTelemetry build() {
            TracerProvider tracerProvider;
            MeterProvider meterProvider = this.meterProvider;
            if (meterProvider == null) {
                MeterProviderFactory meterProviderFactory = (MeterProviderFactory)DefaultOpenTelemetry.loadSpi(MeterProviderFactory.class);
                meterProvider = meterProviderFactory != null ? meterProviderFactory.create() : MeterProvider.getDefault();
            }
            if ((tracerProvider = this.tracerProvider) == null) {
                TracerProviderFactory tracerProviderFactory = (TracerProviderFactory)DefaultOpenTelemetry.loadSpi(TracerProviderFactory.class);
                tracerProvider = tracerProviderFactory != null ? tracerProviderFactory.create() : TracerProvider.getDefault();
            }
            return new DefaultOpenTelemetry(tracerProvider, meterProvider, this.propagators);
        }
    }
}

