/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.baggage.AutoValue_Entry;
import io.opentelemetry.api.baggage.EntryMetadata;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.internal.Utils;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class Entry {
    Entry() {
    }

    static Entry create(String key, String value, EntryMetadata entryMetadata) {
        Utils.checkArgument(Entry.keyIsValid(key), "Invalid entry key name: %s", key);
        Utils.checkArgument(Entry.isValueValid(value), "Invalid entry value: %s", value);
        return new AutoValue_Entry(key, value, entryMetadata);
    }

    abstract String getKey();

    abstract String getValue();

    abstract EntryMetadata getEntryMetadata();

    private static boolean keyIsValid(String name) {
        return !name.isEmpty() && StringUtils.isPrintableString(name);
    }

    private static boolean isValueValid(String value) {
        return StringUtils.isPrintableString(value);
    }
}

