/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeConsumer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AutoValue_Attributes_ArrayBackedAttributes;
import io.opentelemetry.api.common.ImmutableKeyValuePairs;
import io.opentelemetry.api.common.ReadableAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Attributes
extends ImmutableKeyValuePairs<AttributeKey, Object>
implements ReadableAttributes {
    private static final Attributes EMPTY = Attributes.builder().build();

    @Override
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    @Override
    public void forEach(AttributeConsumer consumer) {
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            consumer.accept((AttributeKey)data.get(i), data.get(i + 1));
        }
    }

    public static Attributes empty() {
        return EMPTY;
    }

    public static <T> Attributes of(AttributeKey<T> key, T value) {
        return Attributes.sortAndFilterToAttributes(key, value);
    }

    public static <T, U> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2);
    }

    public static <T, U, V> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3);
    }

    public static <T, U, V, W> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static <T, U, V, W, X> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4, AttributeKey<X> key5, X value5) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static <T, U, V, W, X, Y> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4, AttributeKey<X> key5, X value5, AttributeKey<Y> key6, Y value6) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
    }

    private static Attributes sortAndFilterToAttributes(Object ... data) {
        for (int i = 0; i < data.length; i += 2) {
            AttributeKey key = (AttributeKey)data[i];
            if (key != null && (key.getKey() == null || "".equals(key.getKey()))) {
                data[i] = null;
            }
            if (data[i + 1] != null) continue;
            data[i] = null;
        }
        return new AutoValue_Attributes_ArrayBackedAttributes(Attributes.sortAndFilter(data));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReadableAttributes attributes) {
        Builder builder = new Builder();
        attributes.forEach(builder::put);
        return builder;
    }

    public abstract Builder toBuilder();

    public static class Builder {
        private final List<Object> data;

        private Builder() {
            this.data = new ArrayList<Object>();
        }

        private Builder(List<Object> data) {
            this.data = data;
        }

        public Attributes build() {
            return Attributes.sortAndFilterToAttributes(this.data.toArray());
        }

        public <T> Builder put(AttributeKey<Long> key, int value) {
            return this.put(key, Long.valueOf(value));
        }

        public <T> Builder put(AttributeKey<T> key, T value) {
            if (key == null || key.getKey() == null || key.getKey().length() == 0 || value == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(value);
            return this;
        }

        public Builder put(String key, String value) {
            return this.put(AttributeKey.stringKey(key), value);
        }

        public Builder put(String key, long value) {
            return this.put(AttributeKey.longKey(key), Long.valueOf(value));
        }

        public Builder put(String key, double value) {
            return this.put(AttributeKey.doubleKey(key), Double.valueOf(value));
        }

        public Builder put(String key, boolean value) {
            return this.put(AttributeKey.booleanKey(key), Boolean.valueOf(value));
        }

        public Builder put(String key, String ... value) {
            return this.put(AttributeKey.stringArrayKey(key), value == null ? null : Arrays.asList(value));
        }

        public Builder put(String key, Long ... value) {
            return this.put(AttributeKey.longArrayKey(key), value == null ? null : Arrays.asList(value));
        }

        public Builder put(String key, Double ... value) {
            return this.put(AttributeKey.doubleArrayKey(key), value == null ? null : Arrays.asList(value));
        }

        public Builder put(String key, Boolean ... value) {
            return this.put(AttributeKey.booleanArrayKey(key), value == null ? null : Arrays.asList(value));
        }

        public Builder putAll(Attributes attributes) {
            this.data.addAll(attributes.data());
            return this;
        }
    }

    @AutoValue
    @Immutable
    static abstract class ArrayBackedAttributes
    extends Attributes {
        ArrayBackedAttributes() {
        }

        @Override
        abstract List<Object> data();

        @Override
        public Builder toBuilder() {
            return new Builder(new ArrayList<Object>(this.data()));
        }
    }
}

