/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.EntryMetadata;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class W3CBaggagePropagator
implements TextMapPropagator {
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private static final W3CBaggagePropagator INSTANCE = new W3CBaggagePropagator();

    public static W3CBaggagePropagator getInstance() {
        return INSTANCE;
    }

    private W3CBaggagePropagator() {
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        Baggage baggage = Baggage.fromContext(context);
        if (baggage == null) {
            return;
        }
        StringBuilder headerContent = new StringBuilder();
        baggage.forEach((key, value, metadata) -> {
            headerContent.append(key).append("=").append(value);
            String metadataValue = metadata.getValue();
            if (metadataValue != null && !metadataValue.isEmpty()) {
                headerContent.append(";").append(metadataValue);
            }
            headerContent.append(",");
        });
        if (headerContent.length() > 0) {
            headerContent.setLength(headerContent.length() - 1);
            setter.set(carrier, FIELD, headerContent.toString());
        }
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
        String baggageHeader = getter.get(carrier, FIELD);
        if (baggageHeader == null) {
            return context;
        }
        if (baggageHeader.isEmpty()) {
            return context.with((ImplicitContextKeyed)Baggage.empty());
        }
        BaggageBuilder baggageBuilder = Baggage.builder();
        try {
            W3CBaggagePropagator.extractEntries(baggageHeader, baggageBuilder);
        }
        catch (Exception e) {
            return context.with((ImplicitContextKeyed)Baggage.empty());
        }
        return context.with((ImplicitContextKeyed)baggageBuilder.build());
    }

    private static void extractEntries(String baggageHeader, BaggageBuilder baggageBuilder) {
        String[] entries;
        for (String entry : entries = baggageHeader.split(",")) {
            String metadata = "";
            int beginningOfMetadata = entry.indexOf(";");
            if (beginningOfMetadata > 0) {
                metadata = entry.substring(beginningOfMetadata + 1);
                entry = entry.substring(0, beginningOfMetadata);
            }
            String[] keyAndValue = entry.split("=");
            for (int i = 0; i < keyAndValue.length; i += 2) {
                String key = keyAndValue[i].trim();
                String value = keyAndValue[i + 1].trim();
                baggageBuilder.put(key, value, EntryMetadata.create(metadata.trim()));
            }
        }
    }
}

