/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AutoValue_Labels_ArrayBackedLabels;
import io.opentelemetry.api.common.LabelsBuilder;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Labels
extends ImmutableKeyValuePairs<String, String> {
    private static final Labels EMPTY = Labels.builder().build();

    public abstract void forEach(BiConsumer<String, String> var1);

    public static Labels empty() {
        return EMPTY;
    }

    public static Labels of(String key, String value) {
        return Labels.sortAndFilterToLabels(key, value);
    }

    public static Labels of(String key1, String value1, String key2, String value2) {
        return Labels.sortAndFilterToLabels(key1, value1, key2, value2);
    }

    public static Labels of(String key1, String value1, String key2, String value2, String key3, String value3) {
        return Labels.sortAndFilterToLabels(key1, value1, key2, value2, key3, value3);
    }

    public static Labels of(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4) {
        return Labels.sortAndFilterToLabels(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Labels of(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, String value5) {
        return Labels.sortAndFilterToLabels(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static Labels of(String[] keyValueLabelPairs) {
        return Labels.sortAndFilterToLabels(keyValueLabelPairs);
    }

    static Labels sortAndFilterToLabels(Object ... data) {
        return new AutoValue_Labels_ArrayBackedLabels(Labels.sortAndFilter(data, false));
    }

    public LabelsBuilder toBuilder() {
        return new LabelsBuilder(this.data());
    }

    public static LabelsBuilder builder() {
        return new LabelsBuilder();
    }

    @AutoValue
    @Immutable
    static abstract class ArrayBackedLabels
    extends Labels {
        ArrayBackedLabels() {
        }

        @Override
        protected abstract List<Object> data();

        @Override
        public void forEach(BiConsumer<String, String> consumer) {
            List<Object> data = this.data();
            for (int i = 0; i < data.size(); i += 2) {
                consumer.accept((String)data.get(i), (String)data.get(i + 1));
            }
        }
    }
}

