/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.ArrayBackedLabelsBuilder;
import io.opentelemetry.api.common.AutoValue_Labels_ArrayBackedLabels;
import io.opentelemetry.api.common.LabelsBuilder;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface Labels {
    public void forEach(BiConsumer<String, String> var1);

    public int size();

    @Nullable
    public String get(String var1);

    public boolean isEmpty();

    public static Labels empty() {
        return ArrayBackedLabels.EMPTY;
    }

    public static Labels of(String key, String value) {
        return ArrayBackedLabels.sortAndFilterToLabels(key, value);
    }

    public static Labels of(String key1, String value1, String key2, String value2) {
        return ArrayBackedLabels.sortAndFilterToLabels(key1, value1, key2, value2);
    }

    public static Labels of(String key1, String value1, String key2, String value2, String key3, String value3) {
        return ArrayBackedLabels.sortAndFilterToLabels(key1, value1, key2, value2, key3, value3);
    }

    public static Labels of(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4) {
        return ArrayBackedLabels.sortAndFilterToLabels(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Labels of(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, String value5) {
        return ArrayBackedLabels.sortAndFilterToLabels(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static Labels of(String[] keyValueLabelPairs) {
        return ArrayBackedLabels.sortAndFilterToLabels(keyValueLabelPairs);
    }

    public LabelsBuilder toBuilder();

    public static LabelsBuilder builder() {
        return new ArrayBackedLabelsBuilder();
    }

    @AutoValue
    @Immutable
    public static abstract class ArrayBackedLabels
    extends ImmutableKeyValuePairs<String, String>
    implements Labels {
        private static final Labels EMPTY = Labels.builder().build();

        ArrayBackedLabels() {
        }

        @Override
        protected abstract List<Object> data();

        @Override
        public void forEach(BiConsumer<String, String> consumer) {
            List<Object> data = this.data();
            for (int i = 0; i < data.size(); i += 2) {
                consumer.accept((String)data.get(i), (String)data.get(i + 1));
            }
        }

        static Labels sortAndFilterToLabels(Object ... data) {
            return new AutoValue_Labels_ArrayBackedLabels(ArrayBackedLabels.sortAndFilter(data, false));
        }

        @Override
        public LabelsBuilder toBuilder() {
            return new ArrayBackedLabelsBuilder(this.data());
        }
    }
}

