/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.Utils;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.spi.OpenTelemetryFactory;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GlobalOpenTelemetry {
    private static final Object mutex = new Object();
    @Nullable
    private static volatile OpenTelemetry globalOpenTelemetry;

    private GlobalOpenTelemetry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry get() {
        if (globalOpenTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                if (globalOpenTelemetry == null) {
                    OpenTelemetryFactory openTelemetryFactory = Utils.loadSpi(OpenTelemetryFactory.class);
                    if (openTelemetryFactory != null) {
                        GlobalOpenTelemetry.set(openTelemetryFactory.create());
                    } else {
                        GlobalOpenTelemetry.set(DefaultOpenTelemetry.builder().build());
                    }
                }
            }
        }
        return globalOpenTelemetry;
    }

    public static void set(OpenTelemetry openTelemetry) {
        globalOpenTelemetry = openTelemetry;
    }

    static void reset() {
        globalOpenTelemetry = null;
    }

    public static TracerProvider getTracerProvider() {
        return GlobalOpenTelemetry.get().getTracerProvider();
    }

    public static Tracer getTracer(String instrumentationName) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationName);
    }

    public static Tracer getTracer(String instrumentationName, String instrumentationVersion) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationName, instrumentationVersion);
    }

    @Deprecated
    public static MeterProvider getMeterProvider() {
        return GlobalOpenTelemetry.get().getMeterProvider();
    }

    @Deprecated
    public static Meter getMeter(String instrumentationName) {
        return GlobalOpenTelemetry.get().getMeter(instrumentationName);
    }

    @Deprecated
    public static Meter getMeter(String instrumentationName, String instrumentationVersion) {
        return GlobalOpenTelemetry.get().getMeter(instrumentationName, instrumentationVersion);
    }

    public static ContextPropagators getPropagators() {
        return GlobalOpenTelemetry.get().getPropagators();
    }

    @Deprecated
    public static void setPropagators(ContextPropagators propagators) {
        Objects.requireNonNull(propagators, "propagators");
        GlobalOpenTelemetry.get().setPropagators(propagators);
    }
}

