/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.distributedcontext.unsafe;

import io.grpc.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.distributedcontext.DistributedContext;
import io.opentelemetry.distributedcontext.EmptyDistributedContext;
import io.opentelemetry.distributedcontext.unsafe.DistributedContextInScope;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContextUtils {
    private static final Context.Key<DistributedContext> DIST_CONTEXT_KEY = Context.keyWithDefault((String)"opentelemetry-dist-context-key", (Object)EmptyDistributedContext.getInstance());

    public static Context withValue(DistributedContext distContext) {
        return Context.current().withValue(DIST_CONTEXT_KEY, (Object)distContext);
    }

    public static Context withValue(DistributedContext distContext, Context context) {
        return context.withValue(DIST_CONTEXT_KEY, (Object)distContext);
    }

    public static DistributedContext getValue() {
        return (DistributedContext)DIST_CONTEXT_KEY.get();
    }

    public static DistributedContext getValue(Context context) {
        return (DistributedContext)DIST_CONTEXT_KEY.get(context);
    }

    public static Scope withDistributedContext(DistributedContext distContext) {
        return DistributedContextInScope.create(distContext);
    }

    private ContextUtils() {
    }
}

