/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace.unsafe;

import io.grpc.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.unsafe.SpanInScope;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContextUtils {
    private static final Context.Key<Span> CONTEXT_SPAN_KEY = Context.keyWithDefault((String)"opentelemetry-trace-span-key", (Object)DefaultSpan.getInvalid());

    public static Context withValue(Span span) {
        return Context.current().withValue(CONTEXT_SPAN_KEY, (Object)span);
    }

    public static Context withValue(Span span, Context context) {
        return context.withValue(CONTEXT_SPAN_KEY, (Object)span);
    }

    public static Span getValue() {
        return (Span)CONTEXT_SPAN_KEY.get();
    }

    public static Span getValue(Context context) {
        return (Span)CONTEXT_SPAN_KEY.get(context);
    }

    public static Scope withSpan(Span span) {
        return SpanInScope.create(span);
    }

    private ContextUtils() {
    }
}

