/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace.attributes;

import io.opentelemetry.common.Attributes;
import io.opentelemetry.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringAttributeSetter {
    private final String attributeKey;

    public static StringAttributeSetter create(String attributeKey) {
        return new StringAttributeSetter(attributeKey);
    }

    private StringAttributeSetter(String attributeKey) {
        if (attributeKey == null || attributeKey.length() == 0) {
            throw new IllegalArgumentException("attributeKey cannot be empty");
        }
        this.attributeKey = attributeKey;
    }

    public String key() {
        return this.attributeKey;
    }

    public void set(Span span, @Nullable String value) {
        span.setAttribute(this.key(), value);
    }

    public void set(Span.Builder spanBuilder, @Nullable String value) {
        spanBuilder.setAttribute(this.key(), value);
    }

    public void set(Attributes.Builder attributesBuilder, @Nullable String value) {
        attributesBuilder.setAttribute(this.key(), value);
    }

    public String toString() {
        return this.key();
    }
}

