/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.AutoValue_Attributes_ArrayBackedAttributes;
import io.opentelemetry.common.ImmutableKeyValuePairs;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.common.ReadableKeyValuePairs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Attributes
extends ImmutableKeyValuePairs<AttributeValue>
implements ReadableAttributes {
    private static final Attributes EMPTY = Attributes.newBuilder().build();

    public static Attributes empty() {
        return EMPTY;
    }

    public static Attributes of(String key, AttributeValue value) {
        return Attributes.sortAndFilterToAttributes(key, value);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2, String key3, AttributeValue value3) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2, String key3, AttributeValue value3, String key4, AttributeValue value4) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2, String key3, AttributeValue value3, String key4, AttributeValue value4, String key5, AttributeValue value5) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    private static Attributes sortAndFilterToAttributes(Object ... data) {
        return new AutoValue_Attributes_ArrayBackedAttributes(Attributes.sortAndFilter(data));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ReadableAttributes attributes) {
        final Builder builder = new Builder();
        attributes.forEach(new ReadableKeyValuePairs.KeyValueConsumer<AttributeValue>(){

            @Override
            public void consume(String key, AttributeValue value) {
                builder.setAttribute(key, value);
            }
        });
        return builder;
    }

    public abstract Builder toBuilder();

    public static class Builder {
        private final List<Object> data;

        private Builder() {
            this.data = new ArrayList<Object>();
        }

        private Builder(List<Object> data) {
            this.data = data;
        }

        public Attributes build() {
            return Attributes.sortAndFilterToAttributes(this.data.toArray());
        }

        public Builder setAttribute(String key, AttributeValue value) {
            if (key == null || key.length() == 0) {
                return this;
            }
            if (value == null || value.isNull()) {
                Iterator<Object> itr = this.data.iterator();
                while (itr.hasNext()) {
                    String k = (String)itr.next();
                    if (key.equals(k)) {
                        itr.remove();
                        itr.next();
                        itr.remove();
                        continue;
                    }
                    itr.next();
                }
                return this;
            }
            this.data.add(key);
            this.data.add(value);
            return this;
        }

        public Builder setAttribute(String key, String value) {
            AttributeValue v = AttributeValue.stringAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, long value) {
            AttributeValue v = AttributeValue.longAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, double value) {
            AttributeValue v = AttributeValue.doubleAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, boolean value) {
            AttributeValue v = AttributeValue.booleanAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, String ... value) {
            AttributeValue v = AttributeValue.arrayAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, Long ... value) {
            AttributeValue v = AttributeValue.arrayAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, Double ... value) {
            AttributeValue v = AttributeValue.arrayAttributeValue(value);
            return this.setAttribute(key, v);
        }

        public Builder setAttribute(String key, Boolean ... value) {
            AttributeValue v = AttributeValue.arrayAttributeValue(value);
            return this.setAttribute(key, v);
        }
    }

    @AutoValue
    @Immutable
    static abstract class ArrayBackedAttributes
    extends Attributes {
        ArrayBackedAttributes() {
        }

        @Override
        abstract List<Object> data();

        @Override
        public Builder toBuilder() {
            return new Builder(new ArrayList<Object>(this.data()));
        }
    }
}

