/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.common;

import io.opentelemetry.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class ImmutableKeyValuePairs<K, V> {
    ImmutableKeyValuePairs() {
    }

    List<Object> data() {
        return Collections.emptyList();
    }

    public int size() {
        return this.data().size() / 2;
    }

    public boolean isEmpty() {
        return this.data().isEmpty();
    }

    @Nullable
    public V get(K key) {
        for (int i = 0; i < this.data().size(); i += 2) {
            if (!key.equals(this.data().get(i))) continue;
            return (V)this.data().get(i + 1);
        }
        return null;
    }

    static List<Object> sortAndFilter(Object[] data) {
        Utils.checkArgument(data.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        ImmutableKeyValuePairs.quickSort(data, 0, data.length - 2);
        return ImmutableKeyValuePairs.dedupe(data);
    }

    private static <K extends Comparable<K>> void quickSort(Object[] data, int leftIndex, int rightIndex) {
        if (leftIndex >= rightIndex) {
            return;
        }
        Comparable pivotKey = (Comparable)data[rightIndex];
        int counter = leftIndex;
        for (int i = leftIndex; i <= rightIndex; i += 2) {
            Comparable value = (Comparable)data[i];
            if (ImmutableKeyValuePairs.compareToNullSafe(value, pivotKey) > 0) continue;
            ImmutableKeyValuePairs.swap(data, counter, i);
            counter += 2;
        }
        ImmutableKeyValuePairs.quickSort(data, leftIndex, counter - 4);
        ImmutableKeyValuePairs.quickSort(data, counter, rightIndex);
    }

    private static <K extends Comparable<K>> int compareToNullSafe(K key, K pivotKey) {
        if (key == null) {
            return pivotKey == null ? 0 : -1;
        }
        if (pivotKey == null) {
            return 1;
        }
        return key.compareTo(pivotKey);
    }

    private static List<Object> dedupe(Object[] data) {
        ArrayList<Object> result = new ArrayList<Object>(data.length);
        Object previousKey = null;
        for (int i = data.length - 2; i >= 0; i -= 2) {
            Object key = data[i];
            Object value = data[i + 1];
            if (key == null || key.equals(previousKey)) continue;
            previousKey = key;
            result.add(value);
            result.add(key);
        }
        Collections.reverse(result);
        return result;
    }

    private static void swap(Object[] data, int a, int b) {
        Object keyA = data[a];
        Object valueA = data[a + 1];
        data[a] = data[b];
        data[a + 1] = data[b + 1];
        data[b] = keyA;
        data[b + 1] = valueA;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            sb.append(data.get(i)).append("=").append(data.get(i + 1)).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }
}

