/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;

public interface OpenTelemetry {
    public static OpenTelemetry noop() {
        return DefaultOpenTelemetry.getNoop();
    }

    public static OpenTelemetry propagating(ContextPropagators propagators) {
        return DefaultOpenTelemetry.getPropagating(propagators);
    }

    public TracerProvider getTracerProvider();

    default public MeterProvider getMeterProvider() {
        return MeterProvider.noop();
    }

    default public Tracer getTracer(String instrumentationName) {
        return this.getTracerProvider().get(instrumentationName);
    }

    default public Tracer getTracer(String instrumentationName, String instrumentationVersion) {
        return this.getTracerProvider().get(instrumentationName, instrumentationVersion);
    }

    default public TracerBuilder tracerBuilder(String instrumentationName) {
        return this.getTracerProvider().tracerBuilder(instrumentationName);
    }

    public ContextPropagators getPropagators();
}

