/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.context.Context;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class DefaultMeter
implements Meter {
    private static final DefaultMeter INSTANCE = new DefaultMeter();

    public static Meter getInstance() {
        return INSTANCE;
    }

    @Override
    public LongCounterBuilder counterBuilder(String name) {
        return new NoopLongCounterBuilder();
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return new NoopLongUpDownCounterBuilder();
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String name) {
        return new NoopDoubleHistogramBuilder();
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return new NoopDoubleObservableInstrumentBuilder();
    }

    private DefaultMeter() {
    }

    private static class NoopLongCounterBuilder
    implements LongCounterBuilder {
        private static final ObservableLongCounter NOOP = new ObservableLongCounter(){};

        private NoopLongCounterBuilder() {
        }

        @Override
        public LongCounterBuilder setDescription(String description) {
            return this;
        }

        @Override
        public LongCounterBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return new NoopDoubleCounterBuilder();
        }

        @Override
        public LongCounter build() {
            return new NoopLongCounter();
        }

        @Override
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return NOOP;
        }
    }

    private static class NoopLongUpDownCounterBuilder
    implements LongUpDownCounterBuilder {
        private static final ObservableLongUpDownCounter NOOP = new ObservableLongUpDownCounter(){};

        private NoopLongUpDownCounterBuilder() {
        }

        @Override
        public LongUpDownCounterBuilder setDescription(String description) {
            return this;
        }

        @Override
        public LongUpDownCounterBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder ofDoubles() {
            return new NoopDoubleUpDownCounterBuilder();
        }

        @Override
        public LongUpDownCounter build() {
            return new NoopLongUpDownCounter();
        }

        @Override
        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return NOOP;
        }
    }

    public static class NoopDoubleHistogramBuilder
    implements DoubleHistogramBuilder {
        @Override
        public DoubleHistogramBuilder setDescription(String description) {
            return this;
        }

        @Override
        public DoubleHistogramBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return new NoopLongHistogramBuilder();
        }

        @Override
        public DoubleHistogram build() {
            return new NoopDoubleHistogram();
        }
    }

    public static class NoopDoubleObservableInstrumentBuilder
    implements DoubleGaugeBuilder {
        private static final ObservableDoubleGauge NOOP = new ObservableDoubleGauge(){};

        @Override
        public DoubleGaugeBuilder setDescription(String description) {
            return this;
        }

        @Override
        public DoubleGaugeBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return new NoopLongObservableInstrumentBuilder();
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return NOOP;
        }
    }

    public static class NoopLongObservableInstrumentBuilder
    implements LongGaugeBuilder {
        private static final ObservableLongGauge NOOP = new ObservableLongGauge(){};

        @Override
        public LongGaugeBuilder setDescription(String description) {
            return this;
        }

        @Override
        public LongGaugeBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return NOOP;
        }
    }

    public static class NoopLongHistogramBuilder
    implements LongHistogramBuilder {
        @Override
        public LongHistogramBuilder setDescription(String description) {
            return this;
        }

        @Override
        public LongHistogramBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public LongHistogram build() {
            return new NoopLongHistogram();
        }
    }

    public static class NoopLongHistogram
    implements LongHistogram {
        @Override
        public void record(long value, Attributes attributes, Context context) {
        }

        @Override
        public void record(long value, Attributes attributes) {
        }

        @Override
        public void record(long value) {
        }
    }

    public static class NoopDoubleHistogram
    implements DoubleHistogram {
        @Override
        public void record(double value, Attributes attributes, Context context) {
        }

        @Override
        public void record(double value, Attributes attributes) {
        }

        @Override
        public void record(double value) {
        }
    }

    private static class NoopDoubleUpDownCounterBuilder
    implements DoubleUpDownCounterBuilder {
        private static final ObservableDoubleUpDownCounter NOOP = new ObservableDoubleUpDownCounter(){};

        private NoopDoubleUpDownCounterBuilder() {
        }

        @Override
        public DoubleUpDownCounterBuilder setDescription(String description) {
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return new NoopDoubleUpDownCounter();
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return NOOP;
        }
    }

    private static class NoopDoubleUpDownCounter
    implements DoubleUpDownCounter {
        private NoopDoubleUpDownCounter() {
        }

        @Override
        public void add(double value, Attributes attributes, Context context) {
        }

        @Override
        public void add(double value, Attributes attributes) {
        }

        @Override
        public void add(double value) {
        }
    }

    private static class NoopLongUpDownCounter
    implements LongUpDownCounter {
        private NoopLongUpDownCounter() {
        }

        @Override
        public void add(long value, Attributes attributes, Context context) {
        }

        @Override
        public void add(long value, Attributes attributes) {
        }

        @Override
        public void add(long value) {
        }
    }

    private static class NoopDoubleCounterBuilder
    implements DoubleCounterBuilder {
        private static final ObservableDoubleCounter NOOP = new ObservableDoubleCounter(){};

        private NoopDoubleCounterBuilder() {
        }

        @Override
        public DoubleCounterBuilder setDescription(String description) {
            return this;
        }

        @Override
        public DoubleCounterBuilder setUnit(String unit) {
            return this;
        }

        @Override
        public DoubleCounter build() {
            return new NoopDoubleCounter();
        }

        @Override
        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return NOOP;
        }
    }

    private static class NoopDoubleCounter
    implements DoubleCounter {
        private NoopDoubleCounter() {
        }

        @Override
        public void add(double value, Attributes attributes, Context context) {
        }

        @Override
        public void add(double value, Attributes attributes) {
        }

        @Override
        public void add(double value) {
        }
    }

    private static class NoopLongCounter
    implements LongCounter {
        private NoopLongCounter() {
        }

        @Override
        public void add(long value, Attributes attributes, Context context) {
        }

        @Override
        public void add(long value, Attributes attributes) {
        }

        @Override
        public void add(long value) {
        }
    }
}

