/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import io.grpc.Context;
import io.opentelemetry.context.Scope;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContextUtils {
    public static Scope withScopedContext(Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return new ContextInScope(context);
    }

    private ContextUtils() {
    }

    private static final class ContextInScope
    implements Scope {
        private final Context context;
        private final Context previous;

        public ContextInScope(Context context) {
            this.context = context;
            this.previous = context.attach();
        }

        @Override
        public void close() {
            this.context.detach(this.previous);
        }
    }
}

