/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.contrib.trace.propagation.B3PropagatorInjector;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorInjectorMultipleHeaders
implements B3PropagatorInjector {
    B3PropagatorInjectorMultipleHeaders() {
    }

    @Override
    public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(setter, "setter");
        Span span = TracingContextUtils.getSpanWithoutDefault((Context)context);
        if (span == null || !span.getContext().isValid()) {
            return;
        }
        SpanContext spanContext = span.getContext();
        String sampled = spanContext.getTraceFlags().isSampled() ? "1" : "0";
        setter.set(carrier, "X-B3-TraceId", spanContext.getTraceId().toLowerBase16());
        setter.set(carrier, "X-B3-SpanId", spanContext.getSpanId().toLowerBase16());
        setter.set(carrier, "X-B3-Sampled", sampled);
    }
}

