/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.contrib.trace.propagation.B3PropagatorInjector;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorInjectorSingleHeader
implements B3PropagatorInjector {
    private static final int SAMPLED_FLAG_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 2 * TraceId.getSize();
    private static final int SPAN_ID_HEX_SIZE = 2 * SpanId.getSize();
    private static final int COMBINED_HEADER_DELIMITER_SIZE = 1;
    private static final int SPAN_ID_OFFSET = TRACE_ID_HEX_SIZE + 1;
    private static final int SAMPLED_FLAG_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int COMBINED_HEADER_SIZE = SAMPLED_FLAG_OFFSET + 1;

    B3PropagatorInjectorSingleHeader() {
    }

    @Override
    public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(setter, "setter");
        Span span = TracingContextUtils.getSpanWithoutDefault((Context)context);
        if (span == null || !span.getContext().isValid()) {
            return;
        }
        SpanContext spanContext = span.getContext();
        char[] chars = new char[COMBINED_HEADER_SIZE];
        spanContext.getTraceId().copyLowerBase16To(chars, 0);
        chars[B3PropagatorInjectorSingleHeader.SPAN_ID_OFFSET - 1] = 45;
        spanContext.getSpanId().copyLowerBase16To(chars, SPAN_ID_OFFSET);
        chars[B3PropagatorInjectorSingleHeader.SAMPLED_FLAG_OFFSET - 1] = 45;
        chars[B3PropagatorInjectorSingleHeader.SAMPLED_FLAG_OFFSET] = spanContext.getTraceFlags().isSampled() ? 49 : 48;
        setter.set(carrier, "b3", new String(chars));
    }
}

