/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import io.opentelemetry.trace.TracingContextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JaegerPropagator
implements HttpTextFormat {
    private static final Logger logger = Logger.getLogger(JaegerPropagator.class.getName());
    static final String PROPAGATION_HEADER = "uber-trace-id";
    static final char DEPRECATED_PARENT_SPAN = '0';
    static final char PROPAGATION_HEADER_DELIMITER = ':';
    private static final int MAX_TRACE_ID_LENGTH = 2 * TraceId.getSize();
    private static final int MAX_SPAN_ID_LENGTH = 2 * SpanId.getSize();
    private static final int MAX_FLAGS_LENGTH = 2;
    private static final char IS_SAMPLED = '1';
    private static final char NOT_SAMPLED = '0';
    private static final int PROPAGATION_HEADER_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 2 * TraceId.getSize();
    private static final int SPAN_ID_HEX_SIZE = 2 * SpanId.getSize();
    private static final int PARENT_SPAN_ID_SIZE = 1;
    private static final int SAMPLED_FLAG_SIZE = 1;
    private static final int SPAN_ID_OFFSET = TRACE_ID_HEX_SIZE + 1;
    private static final int PARENT_SPAN_ID_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int SAMPLED_FLAG_OFFSET = PARENT_SPAN_ID_OFFSET + 1 + 1;
    private static final int PROPAGATION_HEADER_SIZE = SAMPLED_FLAG_OFFSET + 1;
    private static final TraceFlags SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(true).build();
    private static final TraceFlags NOT_SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(false).build();
    private static final List<String> FIELDS = Collections.singletonList("uber-trace-id");

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        Utils.checkNotNull((Object)context, (Object)"context");
        Utils.checkNotNull(setter, (Object)"setter");
        Span span = TracingContextUtils.getSpanWithoutDefault((Context)context);
        if (span == null || !span.getContext().isValid()) {
            return;
        }
        SpanContext spanContext = span.getContext();
        char[] chars = new char[PROPAGATION_HEADER_SIZE];
        spanContext.getTraceId().copyLowerBase16To(chars, 0);
        chars[JaegerPropagator.SPAN_ID_OFFSET - 1] = 58;
        spanContext.getSpanId().copyLowerBase16To(chars, SPAN_ID_OFFSET);
        chars[JaegerPropagator.PARENT_SPAN_ID_OFFSET - 1] = 58;
        chars[JaegerPropagator.PARENT_SPAN_ID_OFFSET] = 48;
        chars[JaegerPropagator.SAMPLED_FLAG_OFFSET - 1] = 58;
        chars[JaegerPropagator.SAMPLED_FLAG_OFFSET] = spanContext.getTraceFlags().isSampled() ? 49 : 48;
        setter.set(carrier, PROPAGATION_HEADER, new String(chars));
    }

    public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
        Utils.checkNotNull(carrier, (Object)"carrier");
        Utils.checkNotNull(getter, (Object)"getter");
        SpanContext spanContext = JaegerPropagator.getSpanContextFromHeader(carrier, getter);
        return TracingContextUtils.withSpan((Span)DefaultSpan.create((SpanContext)spanContext), (Context)context);
    }

    private static <C> SpanContext getSpanContextFromHeader(C carrier, HttpTextFormat.Getter<C> getter) {
        String[] parts;
        String value = getter.get(carrier, PROPAGATION_HEADER);
        if (StringUtils.isNullOrEmpty((String)value)) {
            return SpanContext.getInvalid();
        }
        if (value.lastIndexOf(58) == -1) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.info("Error decoding 'uber-trace-id' with value " + value + ". Returning INVALID span context.");
                return SpanContext.getInvalid();
            }
        }
        if ((parts = value.split(String.valueOf(':'))).length != 4) {
            logger.info("Invalid header 'uber-trace-id' with value " + value + ". Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String traceId = parts[0];
        if (!JaegerPropagator.isTraceIdValid(traceId)) {
            logger.info("Invalid TraceId in Jaeger header: 'uber-trace-id' with traceId " + traceId + ". Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = parts[1];
        if (!JaegerPropagator.isSpanIdValid(spanId)) {
            logger.info("Invalid SpanId in Jaeger header: 'uber-trace-id'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String flags = parts[3];
        if (!JaegerPropagator.isFlagsValid(flags)) {
            logger.info("Invalid Flags in Jaeger header: 'uber-trace-id'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        return JaegerPropagator.buildSpanContext(traceId, spanId, flags);
    }

    private static SpanContext buildSpanContext(String traceId, String spanId, String flags) {
        try {
            int flagsInt = Integer.parseInt(flags);
            TraceFlags traceFlags = (flagsInt & 1) == 1 ? SAMPLED_FLAGS : NOT_SAMPLED_FLAGS;
            return SpanContext.createFromRemoteParent((TraceId)TraceId.fromLowerBase16((CharSequence)StringUtils.padLeft((String)traceId, (int)MAX_TRACE_ID_LENGTH), (int)0), (SpanId)SpanId.fromLowerBase16((CharSequence)StringUtils.padLeft((String)spanId, (int)MAX_SPAN_ID_LENGTH), (int)0), (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error parsing 'uber-trace-id' header. Returning INVALID span context.", e);
            return SpanContext.getInvalid();
        }
    }

    private static boolean isTraceIdValid(String value) {
        return !StringUtils.isNullOrEmpty((String)value) && value.length() <= MAX_TRACE_ID_LENGTH;
    }

    private static boolean isSpanIdValid(String value) {
        return !StringUtils.isNullOrEmpty((String)value) && value.length() <= MAX_SPAN_ID_LENGTH;
    }

    private static boolean isFlagsValid(String value) {
        return !StringUtils.isNullOrEmpty((String)value) && value.length() <= 2;
    }
}

