/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.jaeger.MarshalerCollectorServiceGrpc;
import io.opentelemetry.exporter.jaeger.PostSpansRequestMarshaler;
import io.opentelemetry.exporter.jaeger.PostSpansResponse;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JaegerGrpcSpanExporter
implements SpanExporter {
    private static final String DEFAULT_HOST_NAME = "unknown";
    private static final AttributeKey<String> CLIENT_VERSION_KEY = AttributeKey.stringKey((String)"jaeger.version");
    private static final String CLIENT_VERSION_VALUE = "opentelemetry-java";
    private static final AttributeKey<String> HOSTNAME_KEY = AttributeKey.stringKey((String)"hostname");
    private static final AttributeKey<String> IP_KEY = AttributeKey.stringKey((String)"ip");
    private static final String IP_DEFAULT = "0.0.0.0";
    private final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(JaegerGrpcSpanExporter.class.getName()));
    private final MarshalerCollectorServiceGrpc.CollectorServiceFutureStub stub;
    private final Resource jaegerResource;
    private final ManagedChannel managedChannel;
    private final long timeoutNanos;

    JaegerGrpcSpanExporter(ManagedChannel channel, long timeoutNanos) {
        String ipv4;
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            ipv4 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostname = DEFAULT_HOST_NAME;
            ipv4 = IP_DEFAULT;
        }
        this.jaegerResource = Resource.builder().put(CLIENT_VERSION_KEY, (Object)CLIENT_VERSION_VALUE).put(IP_KEY, (Object)ipv4).put(HOSTNAME_KEY, (Object)hostname).build();
        this.managedChannel = channel;
        this.stub = MarshalerCollectorServiceGrpc.newFutureStub((Channel)channel);
        this.timeoutNanos = timeoutNanos;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        MarshalerCollectorServiceGrpc.CollectorServiceFutureStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerCollectorServiceGrpc.CollectorServiceFutureStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        ArrayList requests = new ArrayList();
        spans.stream().collect(Collectors.groupingBy(SpanData::getResource)).forEach((resource, spanData) -> requests.add(this.buildRequest((Resource)resource, (List<SpanData>)spanData)));
        ArrayList<ListenableFuture<PostSpansResponse>> listenableFutures = new ArrayList<ListenableFuture<PostSpansResponse>>(requests.size());
        for (PostSpansRequestMarshaler request : requests) {
            listenableFutures.add(stub.postSpans(request));
        }
        final CompletableResultCode result = new CompletableResultCode();
        final AtomicInteger pending = new AtomicInteger(listenableFutures.size());
        final AtomicReference error = new AtomicReference();
        for (ListenableFuture listenableFuture : listenableFutures) {
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<PostSpansResponse>(){

                public void onSuccess(PostSpansResponse result2) {
                    this.fulfill();
                }

                public void onFailure(Throwable t) {
                    error.set(t);
                    this.fulfill();
                }

                private void fulfill() {
                    if (pending.decrementAndGet() == 0) {
                        Throwable t = (Throwable)error.get();
                        if (t != null) {
                            JaegerGrpcSpanExporter.this.logger.log(Level.WARNING, "Failed to export spans", t);
                            result.fail();
                        } else {
                            result.succeed();
                        }
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return result;
    }

    private PostSpansRequestMarshaler buildRequest(Resource resource, List<SpanData> spans) {
        Resource mergedResource = this.jaegerResource.merge(resource);
        return PostSpansRequestMarshaler.create(spans, mergedResource);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static JaegerGrpcSpanExporterBuilder builder() {
        return new JaegerGrpcSpanExporterBuilder();
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        this.managedChannel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, () -> ((CompletableResultCode)result).succeed());
        if (this.managedChannel.isShutdown()) {
            return result.succeed();
        }
        this.managedChannel.shutdown();
        return result;
    }

    Resource getJaegerResource() {
        return this.jaegerResource;
    }

    ManagedChannel getManagedChannel() {
        return this.managedChannel;
    }
}

