/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import io.opentelemetry.exporter.logging.otlp.JsonUtil;
import io.opentelemetry.exporter.otlp.internal.logs.ResourceLogsMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpJsonLoggingLogExporter
implements LogExporter {
    private static final Logger logger = Logger.getLogger(OtlpJsonLoggingLogExporter.class.getName());

    public static LogExporter create() {
        return new OtlpJsonLoggingLogExporter();
    }

    private OtlpJsonLoggingLogExporter() {
    }

    public CompletableResultCode export(Collection<LogData> logs) {
        ResourceLogsMarshaler[] allResourceLogs;
        for (ResourceLogsMarshaler resourceLogs : allResourceLogs = ResourceLogsMarshaler.create(logs)) {
            SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
            try (JsonGenerator gen = JsonUtil.create(sw);){
                resourceLogs.writeJsonTo(gen);
            }
            catch (IOException e) {
                continue;
            }
            logger.log(Level.INFO, sw.getAndClear());
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

