/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import io.opentelemetry.exporter.logging.otlp.JsonUtil;
import io.opentelemetry.exporter.otlp.internal.metrics.ResourceMetricsMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpJsonLoggingMetricExporter
implements MetricExporter {
    private static final Logger logger = Logger.getLogger(OtlpJsonLoggingMetricExporter.class.getName());

    public static MetricExporter create() {
        return new OtlpJsonLoggingMetricExporter();
    }

    private OtlpJsonLoggingMetricExporter() {
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        ResourceMetricsMarshaler[] allResourceMetrics;
        for (ResourceMetricsMarshaler resourceMetrics : allResourceMetrics = ResourceMetricsMarshaler.create(metrics)) {
            SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
            try (JsonGenerator gen = JsonUtil.create(sw);){
                resourceMetrics.writeJsonTo(gen);
            }
            catch (IOException e) {
                continue;
            }
            logger.log(Level.INFO, sw.getAndClear());
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

