/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import com.google.protobuf.ByteString;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.exporter.otlp.internal.CommonAdapter;
import io.opentelemetry.exporter.otlp.internal.ResourceAdapter;
import io.opentelemetry.proto.trace.v1.InstrumentationLibrarySpans;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SpanAdapter {
    public static List<ResourceSpans> toProtoResourceSpans(Collection<SpanData> spanDataList) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Span>>> resourceAndLibraryMap = SpanAdapter.groupByResourceAndLibrary(spanDataList);
        ArrayList<ResourceSpans> resourceSpans = new ArrayList<ResourceSpans>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Span>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibrarySpans> instrumentationLibrarySpans = new ArrayList<InstrumentationLibrarySpans>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Span>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibrarySpans.add(InstrumentationLibrarySpans.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllSpans((Iterable)entryLibrary.getValue()).build());
            }
            resourceSpans.add(ResourceSpans.newBuilder().setResource(ResourceAdapter.toProtoResource(entryResource.getKey())).addAllInstrumentationLibrarySpans(instrumentationLibrarySpans).build());
        }
        return resourceSpans;
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Span>>> groupByResourceAndLibrary(Collection<SpanData> spanDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Span>>> result = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Span>>>();
        for (SpanData spanData : spanDataList) {
            ArrayList<Span> spanList;
            Resource resource = spanData.getResource();
            HashMap<InstrumentationLibraryInfo, ArrayList<Span>> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, ArrayList<Span>>)result.get(spanData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, ArrayList<Span>>();
                result.put(resource, libraryInfoListMap);
            }
            if ((spanList = (ArrayList<Span>)libraryInfoListMap.get(spanData.getInstrumentationLibraryInfo())) == null) {
                spanList = new ArrayList<Span>();
                libraryInfoListMap.put(spanData.getInstrumentationLibraryInfo(), spanList);
            }
            spanList.add(SpanAdapter.toProtoSpan(spanData));
        }
        return result;
    }

    static Span toProtoSpan(SpanData spanData) {
        Span.Builder builder = Span.newBuilder();
        builder.setTraceId(ByteString.copyFrom((byte[])spanData.getSpanContext().getTraceIdBytes()));
        builder.setSpanId(ByteString.copyFrom((byte[])spanData.getSpanContext().getSpanIdBytes()));
        if (spanData.getParentSpanContext().isValid()) {
            builder.setParentSpanId(ByteString.copyFrom((byte[])spanData.getParentSpanContext().getSpanIdBytes()));
        }
        builder.setName(spanData.getName());
        builder.setKind(SpanAdapter.toProtoSpanKind(spanData.getKind()));
        builder.setStartTimeUnixNano(spanData.getStartEpochNanos());
        builder.setEndTimeUnixNano(spanData.getEndEpochNanos());
        spanData.getAttributes().forEach((key, value) -> builder.addAttributes(CommonAdapter.toProtoAttribute(key, value)));
        builder.setDroppedAttributesCount(spanData.getTotalAttributeCount() - spanData.getAttributes().size());
        for (EventData event : spanData.getEvents()) {
            builder.addEvents(SpanAdapter.toProtoSpanEvent(event));
        }
        builder.setDroppedEventsCount(spanData.getTotalRecordedEvents() - spanData.getEvents().size());
        for (LinkData link : spanData.getLinks()) {
            builder.addLinks(SpanAdapter.toProtoSpanLink(link));
        }
        builder.setDroppedLinksCount(spanData.getTotalRecordedLinks() - spanData.getLinks().size());
        builder.setStatus(SpanAdapter.toStatusProto(spanData.getStatus()));
        return builder.build();
    }

    static Span.SpanKind toProtoSpanKind(SpanKind kind) {
        switch (kind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.UNRECOGNIZED;
    }

    static Span.Event toProtoSpanEvent(EventData event) {
        Span.Event.Builder builder = Span.Event.newBuilder();
        builder.setName(event.getName());
        builder.setTimeUnixNano(event.getEpochNanos());
        event.getAttributes().forEach((key, value) -> builder.addAttributes(CommonAdapter.toProtoAttribute(key, value)));
        builder.setDroppedAttributesCount(event.getTotalAttributeCount() - event.getAttributes().size());
        return builder.build();
    }

    static Span.Link toProtoSpanLink(LinkData link) {
        Span.Link.Builder builder = Span.Link.newBuilder();
        builder.setTraceId(ByteString.copyFrom((byte[])link.getSpanContext().getTraceIdBytes()));
        builder.setSpanId(ByteString.copyFrom((byte[])link.getSpanContext().getSpanIdBytes()));
        Attributes attributes = link.getAttributes();
        attributes.forEach((key, value) -> builder.addAttributes(CommonAdapter.toProtoAttribute(key, value)));
        builder.setDroppedAttributesCount(link.getTotalAttributeCount() - attributes.size());
        return builder.build();
    }

    static Status toStatusProto(StatusData status) {
        Status.StatusCode protoStatusCode = Status.StatusCode.STATUS_CODE_UNSET;
        Status.DeprecatedStatusCode deprecatedStatusCode = Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK;
        if (status.getStatusCode() == StatusCode.OK) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
        } else if (status.getStatusCode() == StatusCode.ERROR) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_ERROR;
            deprecatedStatusCode = Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_UNKNOWN_ERROR;
        }
        Status.Builder builder = Status.newBuilder().setCode(protoStatusCode).setDeprecatedCode(deprecatedStatusCode);
        if (!status.getDescription().isEmpty()) {
            builder.setMessage(status.getDescription());
        }
        return builder.build();
    }

    private SpanAdapter() {
    }
}

