/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.internal.Utf8;
import io.opentelemetry.exporter.otlp.internal.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class CodedOutputStream {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final int DEFAULT_BUFFER_SIZE;
    private static final ThreadLocal<OutputStreamEncoder> THREAD_LOCAL_CODED_OUTPUT_STREAM;

    static CodedOutputStream newInstance(OutputStream output) {
        OutputStreamEncoder cos = THREAD_LOCAL_CODED_OUTPUT_STREAM.get();
        if (cos == null) {
            cos = new OutputStreamEncoder(output);
            THREAD_LOCAL_CODED_OUTPUT_STREAM.set(cos);
        } else {
            cos.reset(output);
        }
        return cos;
    }

    private CodedOutputStream() {
    }

    abstract void writeTag(int var1, int var2) throws IOException;

    abstract void writeInt32(int var1, int var2) throws IOException;

    abstract void writeUInt32(int var1, int var2) throws IOException;

    final void writeSInt32(int fieldNumber, int value) throws IOException {
        this.writeUInt32(fieldNumber, CodedOutputStream.encodeZigZag32(value));
    }

    abstract void writeFixed32(int var1, int var2) throws IOException;

    final void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.writeFixed32(fieldNumber, value);
    }

    final void writeInt64(int fieldNumber, long value) throws IOException {
        this.writeUInt64(fieldNumber, value);
    }

    abstract void writeUInt64(int var1, long var2) throws IOException;

    final void writeSInt64(int fieldNumber, long value) throws IOException {
        this.writeUInt64(fieldNumber, CodedOutputStream.encodeZigZag64(value));
    }

    abstract void writeFixed64(int var1, long var2) throws IOException;

    final void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.writeFixed64(fieldNumber, value);
    }

    final void writeFloat(int fieldNumber, float value) throws IOException {
        this.writeFixed32(fieldNumber, Float.floatToRawIntBits(value));
    }

    final void writeDouble(int fieldNumber, double value) throws IOException {
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value));
    }

    abstract void writeBool(int var1, boolean var2) throws IOException;

    final void writeEnum(int fieldNumber, int value) throws IOException {
        this.writeInt32(fieldNumber, value);
    }

    abstract void writeString(int var1, String var2) throws IOException;

    abstract void writeByteArray(int var1, byte[] var2) throws IOException;

    abstract void writeByteArray(int var1, byte[] var2, int var3, int var4) throws IOException;

    final void writeRawByte(byte value) throws IOException {
        this.write(value);
    }

    final void writeRawByte(int value) throws IOException {
        this.write((byte)value);
    }

    final void writeRawBytes(byte[] value) throws IOException {
        this.write(value, 0, value.length);
    }

    final void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.write(value, offset, length);
    }

    abstract void writeInt32NoTag(int var1) throws IOException;

    abstract void writeUInt32NoTag(int var1) throws IOException;

    final void writeSInt32NoTag(int value) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(value));
    }

    abstract void writeFixed32NoTag(int var1) throws IOException;

    final void writeSFixed32NoTag(int value) throws IOException {
        this.writeFixed32NoTag(value);
    }

    final void writeInt64NoTag(long value) throws IOException {
        this.writeUInt64NoTag(value);
    }

    abstract void writeUInt64NoTag(long var1) throws IOException;

    final void writeSInt64NoTag(long value) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(value));
    }

    abstract void writeFixed64NoTag(long var1) throws IOException;

    final void writeSFixed64NoTag(long value) throws IOException {
        this.writeFixed64NoTag(value);
    }

    final void writeFloatNoTag(float value) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(value));
    }

    final void writeDoubleNoTag(double value) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(value));
    }

    final void writeBoolNoTag(boolean value) throws IOException {
        this.write((byte)(value ? 1 : 0));
    }

    final void writeEnumNoTag(int value) throws IOException {
        this.writeInt32NoTag(value);
    }

    abstract void writeStringNoTag(String var1) throws IOException;

    final void writeByteArrayNoTag(byte[] value) throws IOException {
        this.writeByteArrayNoTag(value, 0, value.length);
    }

    abstract void write(byte var1) throws IOException;

    abstract void write(byte[] var1, int var2, int var3) throws IOException;

    abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    static int computeInt32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(value);
    }

    static int computeUInt32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag(value);
    }

    static int computeSInt32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt32SizeNoTag(value);
    }

    static int computeFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed32SizeNoTag(value);
    }

    static int computeSFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed32SizeNoTag(value);
    }

    static int computeInt64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt64SizeNoTag(value);
    }

    static int computeUInt64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    static int computeSInt64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt64SizeNoTag(value);
    }

    static int computeFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed64SizeNoTag(value);
    }

    static int computeSFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed64SizeNoTag(value);
    }

    static int computeFloatSize(int fieldNumber, float value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFloatSizeNoTag(value);
    }

    static int computeDoubleSize(int fieldNumber, double value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag(value);
    }

    static int computeBoolSize(int fieldNumber, boolean value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag(value);
    }

    static int computeEnumSize(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag(value);
    }

    static int computeStringSize(int fieldNumber, String value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag(value);
    }

    static int computeByteArraySize(int fieldNumber, byte[] value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeByteArraySizeNoTag(value);
    }

    static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(value);
        }
        return 10;
    }

    static int computeUInt32SizeNoTag(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int computeSInt32SizeNoTag(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value));
    }

    static int computeFixed32SizeNoTag(int unused) {
        return 4;
    }

    static int computeSFixed32SizeNoTag(int unused) {
        return 4;
    }

    static int computeInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    static int computeUInt64SizeNoTag(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value >>>= 14;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    static int computeSInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value));
    }

    static int computeFixed64SizeNoTag(long unused) {
        return 8;
    }

    static int computeSFixed64SizeNoTag(long unused) {
        return 8;
    }

    static int computeFloatSizeNoTag(float unused) {
        return 4;
    }

    static int computeDoubleSizeNoTag(double unused) {
        return 8;
    }

    static int computeBoolSizeNoTag(boolean unused) {
        return 1;
    }

    static int computeEnumSizeNoTag(int value) {
        return CodedOutputStream.computeInt32SizeNoTag(value);
    }

    static int computeStringSizeNoTag(String value) {
        int length;
        try {
            length = Utf8.encodedLength(value);
        }
        catch (Utf8.UnpairedSurrogateException e) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            length = bytes.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(length);
    }

    static int computeByteArraySizeNoTag(byte[] value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.length);
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + fieldLength;
    }

    static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    abstract void flush() throws IOException;

    abstract int spaceLeft();

    final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract int getTotalBytesWritten();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    final void inefficientWriteStringNoTag(String value, Utf8.UnpairedSurrogateException cause) throws IOException {
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", cause);
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        try {
            this.writeUInt32NoTag(bytes.length);
            this.writeLazy(bytes, 0, bytes.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new OutOfSpaceException(e);
        }
        catch (OutOfSpaceException e) {
            throw e;
        }
    }

    @Deprecated
    final void writeRawVarint32(int value) throws IOException {
        this.writeUInt32NoTag(value);
    }

    @Deprecated
    final void writeRawVarint64(long value) throws IOException {
        this.writeUInt64NoTag(value);
    }

    @Deprecated
    static int computeRawVarint32Size(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(value);
    }

    @Deprecated
    static int computeRawVarint64Size(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    @Deprecated
    final void writeRawLittleEndian32(int value) throws IOException {
        this.writeFixed32NoTag(value);
    }

    @Deprecated
    final void writeRawLittleEndian64(long value) throws IOException {
        this.writeFixed64NoTag(value);
    }

    static {
        int bufferSize = 51200;
        try {
            bufferSize = Integer.parseInt(System.getProperty("otel.experimental.otlp.buffer-size"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_BUFFER_SIZE = bufferSize;
        THREAD_LOCAL_CODED_OUTPUT_STREAM = new ThreadLocal();
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private OutputStream out;

        OutputStreamEncoder(OutputStream out) {
            super(DEFAULT_BUFFER_SIZE);
            this.out = out;
        }

        void reset(OutputStream out) {
            this.out = out;
            this.position = 0;
            this.totalBytesWritten = 0;
        }

        @Override
        void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        void writeInt32(int fieldNumber, int value) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferInt32NoTag(value);
        }

        @Override
        void writeUInt32(int fieldNumber, int value) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferUInt32NoTag(value);
        }

        @Override
        void writeFixed32(int fieldNumber, int value) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(fieldNumber, 5);
            this.bufferFixed32NoTag(value);
        }

        @Override
        void writeUInt64(int fieldNumber, long value) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferUInt64NoTag(value);
        }

        @Override
        void writeFixed64(int fieldNumber, long value) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(fieldNumber, 1);
            this.bufferFixed64NoTag(value);
        }

        @Override
        void writeBool(int fieldNumber, boolean value) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(fieldNumber, 0);
            this.buffer((byte)(value ? 1 : 0));
        }

        @Override
        void writeString(int fieldNumber, String value) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value);
        }

        @Override
        void writeByteArray(int fieldNumber, byte[] value) throws IOException {
            this.writeByteArray(fieldNumber, value, 0, value.length);
        }

        @Override
        void writeByteArray(int fieldNumber, byte[] value, int offset, int length) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeByteArrayNoTag(value, offset, length);
        }

        @Override
        void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value, offset, length);
        }

        @Override
        void write(byte value) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(value);
        }

        @Override
        void writeInt32NoTag(int value) throws IOException {
            if (value >= 0) {
                this.writeUInt32NoTag(value);
            } else {
                this.writeUInt64NoTag(value);
            }
        }

        @Override
        void writeUInt32NoTag(int value) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(value);
        }

        @Override
        void writeFixed32NoTag(int value) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(value);
        }

        @Override
        void writeUInt64NoTag(long value) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(value);
        }

        @Override
        void writeFixed64NoTag(long value) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(value);
        }

        @Override
        void writeStringNoTag(String value) throws IOException {
            try {
                int maxLength = value.length() * 3;
                int maxLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(maxLength);
                if (maxLengthVarIntSize + maxLength > this.limit) {
                    byte[] encodedBytes = new byte[maxLength];
                    int actualLength = Utf8.encode(value, encodedBytes, 0, maxLength);
                    this.writeUInt32NoTag(actualLength);
                    this.writeLazy(encodedBytes, 0, actualLength);
                    return;
                }
                if (maxLengthVarIntSize + maxLength > this.limit - this.position) {
                    this.doFlush();
                }
                int minLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(value.length());
                int oldPosition = this.position;
                try {
                    int length;
                    if (minLengthVarIntSize == maxLengthVarIntSize) {
                        this.position = oldPosition + minLengthVarIntSize;
                        int newPosition = Utf8.encode(value, this.buffer, this.position, this.limit - this.position);
                        this.position = oldPosition;
                        length = newPosition - oldPosition - minLengthVarIntSize;
                        this.bufferUInt32NoTag(length);
                        this.position = newPosition;
                    } else {
                        length = Utf8.encodedLength(value);
                        this.bufferUInt32NoTag(length);
                        this.position = Utf8.encode(value, this.buffer, this.position, length);
                    }
                    this.totalBytesWritten += length;
                }
                catch (Utf8.UnpairedSurrogateException e) {
                    this.totalBytesWritten -= this.position - oldPosition;
                    this.position = oldPosition;
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new OutOfSpaceException(e);
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.inefficientWriteStringNoTag(value, e);
            }
        }

        @Override
        void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        void write(byte[] value, int offset, int length) throws IOException {
            if (this.limit - this.position >= length) {
                System.arraycopy(value, offset, this.buffer, this.position, length);
                this.position += length;
                this.totalBytesWritten += length;
            } else {
                int bytesWritten = this.limit - this.position;
                System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
                offset += bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                if ((length -= bytesWritten) <= this.limit) {
                    System.arraycopy(value, offset, this.buffer, 0, length);
                    this.position = length;
                } else {
                    this.out.write(value, offset, length);
                }
                this.totalBytesWritten += length;
            }
        }

        @Override
        void writeLazy(byte[] value, int offset, int length) throws IOException {
            this.write(value, offset, length);
        }

        private void flushIfNotAvailable(int requiredSize) throws IOException {
            if (this.limit - this.position < requiredSize) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.limit = this.buffer.length;
        }

        @Override
        final int spaceLeft() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        @Override
        final int getTotalBytesWritten() {
            return this.totalBytesWritten;
        }

        final void buffer(byte value) {
            this.buffer[this.position++] = value;
            ++this.totalBytesWritten;
        }

        final void bufferTag(int fieldNumber, int wireType) {
            this.bufferUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        final void bufferInt32NoTag(int value) {
            if (value >= 0) {
                this.bufferUInt32NoTag(value);
            } else {
                this.bufferUInt64NoTag(value);
            }
        }

        final void bufferUInt32NoTag(int value) {
            while (true) {
                if ((value & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)value;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
                ++this.totalBytesWritten;
                value >>>= 7;
            }
        }

        final void bufferUInt64NoTag(long value) {
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)value;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)value & 0x7F | 0x80);
                ++this.totalBytesWritten;
                value >>>= 7;
            }
        }

        final void bufferFixed32NoTag(int value) {
            this.buffer[this.position++] = (byte)(value & 0xFF);
            this.buffer[this.position++] = (byte)(value >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(value >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(value >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long value) {
            this.buffer[this.position++] = (byte)(value & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(value >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }

    static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;
        private static final String MESSAGE = "CodedOutputStream was writing to a flat byte array and ran out of space.";

        OutOfSpaceException() {
            super(MESSAGE);
        }

        OutOfSpaceException(String explanationMessage) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + explanationMessage);
        }

        OutOfSpaceException(Throwable cause) {
            super(MESSAGE, cause);
        }

        OutOfSpaceException(String explanationMessage, Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + explanationMessage, cause);
        }
    }
}

