/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoSerializer;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.proto.common.v1.internal.InstrumentationLibrary;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

final class InstrumentationLibraryMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<InstrumentationLibraryInfo, InstrumentationLibraryMarshaler> LIBRARY_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction();
    private final byte[] serializedInfo;

    static InstrumentationLibraryMarshaler create(InstrumentationLibraryInfo libraryInfo) {
        InstrumentationLibraryMarshaler cached = (InstrumentationLibraryMarshaler)LIBRARY_MARSHALER_CACHE.get((Object)libraryInfo);
        if (cached == null) {
            byte[] name = MarshalerUtil.toBytes(libraryInfo.getName());
            byte[] version = MarshalerUtil.toBytes(libraryInfo.getVersion());
            cached = new InstrumentationLibraryMarshaler(name, version);
            LIBRARY_MARSHALER_CACHE.put((Object)libraryInfo, (Object)cached);
        }
        return cached;
    }

    private InstrumentationLibraryMarshaler(byte[] name, byte[] version) {
        super(InstrumentationLibraryMarshaler.computeSize(name, version));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.getBinarySerializedSize());
        try (ProtoSerializer serializer = new ProtoSerializer(bos);){
            serializer.serializeString(InstrumentationLibrary.NAME, name);
            serializer.serializeString(InstrumentationLibrary.VERSION, version);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.serializedInfo = bos.toByteArray();
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedInfo, MarshalerUtil.EMPTY_BYTES);
    }

    private static int computeSize(byte[] name, byte[] version) {
        return MarshalerUtil.sizeBytes(InstrumentationLibrary.NAME, name) + MarshalerUtil.sizeBytes(InstrumentationLibrary.VERSION, version);
    }
}

