/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public final class ManagedChannelUtil {
    private static final Logger logger = Logger.getLogger(ManagedChannelUtil.class.getName());

    public static void setTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        TrustManagerFactory tmf = ManagedChannelUtil.trustManagerFactory(trustedCertificatesPem);
        if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
            NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager(tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder")) {
            io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder nettyBuilder = (io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts.forClient().trustManager(tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.okhttp.OkHttpChannelBuilder")) {
            SSLContext sslContext;
            OkHttpChannelBuilder okHttpBuilder = (OkHttpChannelBuilder)managedChannelBuilder;
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new SSLException("Could not build SSLContext.", e);
            }
            okHttpBuilder.sslSocketFactory(sslContext.getSocketFactory());
        } else {
            throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
        }
    }

    private static TrustManagerFactory trustManagerFactory(byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ByteArrayInputStream is = new ByteArrayInputStream(trustedCertificatesPem);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (is.available() > 0) {
                X509Certificate cert = (X509Certificate)factory.generateCertificate(is);
                ks.setCertificateEntry("cert_" + i, cert);
                ++i;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            return tmf;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SSLException("Could not build TrustManagerFactory from trustedCertificatesPem.", e);
        }
    }

    public static CompletableResultCode shutdownChannel(ManagedChannel managedChannel) {
        CompletableResultCode result = new CompletableResultCode();
        managedChannel.shutdown();
        Thread thread = new Thread(() -> {
            try {
                managedChannel.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", e);
                result.fail();
            }
            result.succeed();
        });
        thread.setDaemon(true);
        thread.setName("grpc-cleanup");
        thread.start();
        return result;
    }

    private ManagedChannelUtil() {
    }
}

