/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public final class ProtoRequestBody
extends RequestBody {
    private static final MediaType PROTOBUF_MEDIA_TYPE = MediaType.parse((String)"application/x-protobuf");
    private final Marshaler marshaler;
    private final int contentLength;

    public ProtoRequestBody(Marshaler marshaler) {
        this.marshaler = marshaler;
        this.contentLength = marshaler.getBinarySerializedSize();
    }

    public long contentLength() {
        return this.contentLength;
    }

    public MediaType contentType() {
        return PROTOBUF_MEDIA_TYPE;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.marshaler.writeBinaryTo(bufferedSink.outputStream());
    }
}

