/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.logs;

import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.otlp.internal.okhttp.OkHttpExporter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpLogExporter
implements LogExporter {
    private final OkHttpExporter<LogsRequestMarshaler> delegate;

    OtlpHttpLogExporter(OkHttpExporter<LogsRequestMarshaler> delegate) {
        this.delegate = delegate;
    }

    public static OtlpHttpLogExporter getDefault() {
        return OtlpHttpLogExporter.builder().build();
    }

    public static OtlpHttpLogExporterBuilder builder() {
        return new OtlpHttpLogExporterBuilder();
    }

    public CompletableResultCode export(Collection<LogData> logs) {
        LogsRequestMarshaler exportRequest = LogsRequestMarshaler.create(logs);
        return this.delegate.export((Marshaler)exportRequest, logs.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

